<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Gestión de Agua Potable</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="assets/css/pages/auth.css">
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <!-- Animate.css -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css">
    <link rel="shortcut icon" href="assets/img/favicon.ico" type="image/ico">
    <link rel="stylesheet" href="assets/extensions/sweetalert2/sweetalert2.min.css">
    <style>

    </style>
</head>
<body>

    <video autoplay muted loop preload="metadata" playsinline id="bg-video" class="video-background">
 
        <source src="<?php echo $_SERVER['BASE_URL'];?>assets/media/agua.mp4" type="video/mp4">
    </video>
    

    <div class="video-overlay"></div>

    <div class="bubbles">

    </div>
    

<main>
  <?= $content; ?>
</main>
    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>

        document.addEventListener('DOMContentLoaded', function() {
            const waterEffects = document.querySelector('.water-effects');
            
        
            for (let i = 0; i < 15; i++) {
                createWaterDrop();
            }
            
        
            setInterval(createWaterDrop, 800);
            
            function createWaterDrop() {
                const drop = document.createElement('div');
                drop.classList.add('water-drop');
                
             
                const leftPos = Math.random() * 100;
                const delay = Math.random() * 5;
                const duration = 2 + Math.random() * 3;
                const size = 5 + Math.random() * 15;
                
                drop.style.left = `${leftPos}%`;
                drop.style.width = `${size}px`;
                drop.style.height = `${size}px`;
                drop.style.animationDelay = `${delay}s`;
                drop.style.animationDuration = `${duration}s`;
                
                waterEffects.appendChild(drop);
                
              
                setTimeout(() => {
                    drop.remove();
                }, duration * 1000);
            }
        });
    </script>
        <script>
       
        function resizeVideo() {
            const video = document.getElementById('bg-video');
            const aspectRatio = video.videoWidth / video.videoHeight;
            const windowRatio = window.innerWidth / window.innerHeight;
            
            if (windowRatio > aspectRatio) {
                video.style.width = '100%';
                video.style.height = 'auto';
            } else {
                video.style.width = 'auto';
                video.style.height = '100%';
            }
        }
        
       
        document.getElementById('bg-video').addEventListener('loadedmetadata', function() {
            resizeVideo();
        });
        
        
        window.addEventListener('resize', resizeVideo);
        
        
        document.addEventListener('DOMContentLoaded', function() {
            const video = document.getElementById('bg-video');
            video.play().catch(e => console.log("Error al reproducir video:", e));
        });

        document.querySelector('form').addEventListener('submit', function() {
    document.getElementById('bg-video').pause();
});
    </script>

        <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="js/auth/login.js"></script>
    <script src="assets/extensions/sweetalert2/sweetalert2.min.js"></script>
    <script>
        
        $(document).ready(function() {
            $('.form-control').on('focus', function() {
                $(this).parent().find('.form-control-icon').css('color', '#4361ee');
            }).on('blur', function() {
                $(this).parent().find('.form-control-icon').css('color', '#6c757d');
            });
        });
    </script>
</body>
</html>