<div class="page-content">
    <section class="section">
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between align-items-center">
                            <h4 class="card-title d-flex">Lista de socios</h4>
                            <div class="d-flex gap-2 align-items-center">
                                <label for="zone_id">Barrio:</label>
                                <select name="zone_id" id="zone_id" class="form-select">
                                    <option value="" selected disabled>Seleccionar barrio</option>
                                    <?php foreach ($zones as $zone): ?>
                                        <option value="<?php echo htmlspecialchars($zone['id']); ?>">
                                            <?php echo htmlspecialchars($zone['name']); ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <ul class="list-inline d-flex mb-0">
                                <li class="d-flex align-items-center">
                                    <button id="btnagregar" class="btn btn-outline-primary" onclick="mostrarform(true)"><i
                                            class="bi bi-plus"></i>
                                        Agregar socio</button>
                                </li>
                            </ul>
                        </div>
                        <!--TABLA DE LISTADO DE REGISTROS-->
                        <div class="card-body">
                            <div class="table-responsive" id="listadoregistros">
                                <table id="tbllistado" class="table table-striped table-hover text-nowrap"
                                    style="width:100%;">
                                    <thead>
                                        <th>Opciones</th>
                                        <th>Nombres</th>
                                        <th>Documento</th>
                                        <th>Numero</th>
                                        <th>Telefono</th>
                                        <th>Email</th>
                                        <th>Carnet</th>
                                        <th>Barrio</th>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                    <tfoot>
                                        <th>Opciones</th>
                                        <th>Nombres</th>
                                        <th>Documento</th>
                                        <th>Numero</th>
                                        <th>Telefono</th>
                                        <th>Email</th>
                                        <th>Carnet</th>
                                        <th>Barrio</th>
                                    </tfoot>
                                </table>
                            </div>
                            <!--TABLA DE LISTADO DE REGISTROS FIN-->

                            <!--FORMULARIO PARA DE REGISTRO-->
                            <div id="formularioregistros">
                                <form action="" name="formulario" id="formulario" method="POST">
                                    <div class="row">
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="">Nombre</label>
                                            <input class="form-control" type="hidden" name="id" id="id">
                                            <input class="form-control" type="text" name="name" id="name"
                                                maxlength="100" placeholder="Nombre del cliente" required>
                                        </div>
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="">Apellidos</label>
                                            <input class="form-control" type="text" name="last_name" id="last_name"
                                                maxlength="100" placeholder="Apellidos del cliente" required>
                                        </div>
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="">Número Documento</label>
                                            <input class="form-control" type="text" name="document_number"
                                                id="document_number" maxlength="20" placeholder="Número de Documento">
                                        </div>
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="">Direccion</label>
                                            <input class="form-control" type="text" name="address" id="address"
                                                maxlength="70" placeholder="Direccion">
                                        </div>
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="">Telefono</label>
                                            <input class="form-control" type="text" name="phone" id="phone"
                                                maxlength="20" placeholder="Número de Telefono">
                                        </div>
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="">Email</label>
                                            <input class="form-control" type="email" name="email" id="email"
                                                maxlength="50" placeholder="Email">
                                        </div>
                                        <div class="form-group col-lg-6 col-md-6 col-xs-12">
                                            <label for="zone_search">Barrios/Zonas(*):</label>
                                            <select id="zone_search" class="form-select">
                                                <option value="">Seleccione una zona...</option>
                                                <?php foreach ($zones as $zone): ?>
                                                    <option value="<?php echo $zone['id']; ?>"><?php echo $zone['name']; ?></option>
                                                <?php endforeach; ?>
                                            </select>

                                            <div id="selected_zones_container" class="d-flex flex-wrap gap-2 mb-3 mt-2"></div>

                                            <!-- Este input oculto almacenará los IDs de las zonas seleccionadas -->
                                            <input type="hidden" name="zone_ids" id="zone_ids" value="">
                                        </div>
                                        <div class="form-group col-lg-12 col-md-12 col-sm-12 col-xs-12">
                                            <button class="btn btn-primary" type="submit" id="btnGuardar"><i
                                                    class="fa fa-save"></i> Guardar</button>

                                            <button class="btn btn-danger" onclick="cancelarform()" type="button"><i
                                                    class="fa fa-arrow-circle-left"></i>
                                                Cancelar</button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!--FORMULARIO PARA DE REGISTRO FIN-->
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </section>
</div>