var tabla;

//funcion que se ejecuta al inicio
function init() {

  var now = new Date();
  var day = ("0" + now.getDate()).slice(-2);
  var month = ("0" + (now.getMonth() + 1)).slice(-2);
  var today = now.getFullYear() + "-" + month + "-" + day;
  $("#fecha_inicio").val(today);
  $("#fecha_fin").val(today);

  listar();
  //cargamos los items al select cliente
  $.post("customers/selectClient", function (r) {
    $("#client_id").html(r);

  });

  /*$.get("meters/selectMeter", function (r) {
    $("#meter_id").html(r);

  });*/

  $.get("zones/selectZone", function (r) {
    $("#zone_id").html(r);

  });

  $("#fecha_inicio").change(listar);
  $("#fecha_fin").change(listar);
  $("#client_id").change(listar);
  //$("#meter_id").change(listar);
  $("#zone_id").change(listar);
  //$("#type").change(listar);
}

//funcion listar
function listar() {
  var fecha_inicio = $("#fecha_inicio").val();
  var fecha_fin = $("#fecha_fin").val();
  var client_id = $("#client_id").val();
  //var meter_id = $("#meter_id").val();
  var zone_id = $("#zone_id").val();
  //var type = $("#type").val();

  tabla = $("#tbllistado")
    .dataTable({
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        thousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
      aProcessing: true, //activamos el procedimiento del datatable
      aServerSide: true, //paginacion y filrado realizados por el server
      dom: "Bfrtip", //definimos los elementos del control de la tabla
      buttons: [
        {
          extend: "excelHtml5",
          text: '<i class="fa fa-file-excel-o"></i> Excel',
          titleAttr: "Exportar a Excel",
          title: "Reporte de pagos de "+fecha_inicio+" hasta "+fecha_fin,
          footer:true
        },
        {
          extend: "pdfHtml5",
          text: '<i class="fa fa-file-pdf-o"></i> PDF',
          titleAttr: "Exportar a PDF",
          title: "Reporte de pagos de "+fecha_inicio+" hasta "+fecha_fin,
          footer:true,
        },
      ],
      ajax: {
        url: baseUrl+"report-payments-date/listar",
        data: {
          fecha_inicio: fecha_inicio,
          fecha_fin: fecha_fin,
          client_id: client_id,
          //meter_id: meter_id,
          zone_id: zone_id,
         // type: type,
        },
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      iDisplayLength: 15, //paginacion
      order: [[0, "asc"]], //ordenar (columna, orden)
      drawCallback: function () {
        var api = this.api();
        $(api.column(2).footer()).html('Total');
        $(api.column(3).footer()).html( api.column(3).data().sum().toFixed(2));
      },
    })
    .DataTable();
}

init();
