        document.addEventListener('DOMContentLoaded', function() {
            // Seleccionar elementos
            const whatsappBtn = document.getElementById('whatsappButton');
            const whatsappChat = document.getElementById('whatsappChat');
            const chatHeader = document.getElementById('chatHeader');
            const whatsappForm = document.getElementById('whatsappForm');
            
            // Función para alternar el chat
            function toggleChat() {
                whatsappChat.classList.toggle('active');
                
                if (whatsappChat.classList.contains('active')) {
                    whatsappBtn.classList.add('hidden');
                    setTimeout(() => {
                        document.getElementById('whatsappMessage').focus();
                    }, 300);
                } else {
                    whatsappBtn.classList.remove('hidden');
                }
            }
            
            // Evento click en el botón de WhatsApp
            whatsappBtn.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleChat();
            });
            
            // Evento click en el header del chat
            chatHeader.addEventListener('click', function(e) {
                e.stopPropagation();
                toggleChat();
            });
            
            // Evento submit del formulario
            whatsappForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const message = document.getElementById('whatsappMessage').value;
                
                if (message.trim() !== '') {
                    const phoneNumber = '51912367086'; // Reemplaza con tu número
                    window.open(`https://wa.me/${phoneNumber}?text=${encodeURIComponent(message)}`, '_blank');
                    document.getElementById('whatsappMessage').value = '';
                    toggleChat();
                }
            });
            
            // Cerrar chat al hacer click fuera
            document.addEventListener('click', function() {
                if (whatsappChat.classList.contains('active')) {
                    toggleChat();
                }
            });
            
            // Prevenir que el click en el chat lo cierre
            whatsappChat.addEventListener('click', function(e) {
                e.stopPropagation();
            });
            
            // Autoajustar altura del textarea
            const textarea = document.getElementById('whatsappMessage');
            textarea.addEventListener('input', function() {
                this.style.height = 'auto';
                this.style.height = (this.scrollHeight) + 'px';
            });
        });