"use strict";
var tabla;

//funcion que se ejecuta al inicio
function init() {
  mostrarform(false);
  listar();
$('#zone_id').change(listar);
    // Manejar la adición de zonas
  // Cambio principal: detectar cambio en el select
  $("#zone_search").change(function() {
    const zoneSelect = this;
    const selectedId = zoneSelect.value;
    
    if (selectedId) {
      const selectedText = zoneSelect.options[zoneSelect.selectedIndex].text;
      
      // Verificar si ya está seleccionada
      if ($(`#zone_chip_${selectedId}`).length === 0) {
        // Crear el chip/etiqueta
        const chip = `
          <div class="btn-group" id="zone_chip_${selectedId}">
            <button type="button" class="btn btn-sm btn-outline-primary">${selectedText}</button>
            <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeZone('${selectedId}')">
              <i class="fa fa-times"></i>
            </button>
          </div>
        `;
        
        $('#selected_zones_container').append(chip);
        updateHiddenZones();
      }
      
      // Resetear el select
      zoneSelect.value = '';
    }
  });

  $("#formulario").on("submit", function (e) {
    guardaryeditar(e);
  });
}

// Agregar zona seleccionada
/*function addSelectedZone() {
  const zoneSelect = document.getElementById('zone_search');
  const selectedId = zoneSelect.value;
  const selectedText = zoneSelect.options[zoneSelect.selectedIndex].text;
  
  if (!selectedId) return;
  
  // Verificar si ya está seleccionada
  if ($(`#zone_chip_${selectedId}`).length > 0) return;
  
  // Crear el chip/etiqueta
  const chip = `
    <div class="btn-group" id="zone_chip_${selectedId}">
      <button type="button" class="btn btn-sm btn-outline-primary">${selectedText}</button>
      <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeZone('${selectedId}')">
        <i class="fa fa-times"></i>
      </button>
    </div>
  `;
  
  $('#selected_zones_container').append(chip);
  updateHiddenZones();
  
  // Resetear el select
  zoneSelect.value = '';
}*/

// Eliminar zona seleccionada
function removeZone(zoneId) {
  $(`#zone_chip_${zoneId}`).remove();
  updateHiddenZones();
}

// Actualizar el input hidden con las zonas seleccionadas
function updateHiddenZones() {
  const zoneIds = [];
  $('[id^="zone_chip_"]').each(function() {
    const id = this.id.replace('zone_chip_', '');
    zoneIds.push(id);
  });
  // Cambiamos a JSON string que luego se puede parsear como array
  $('#zone_ids').val(JSON.stringify(zoneIds));
}
//funcion limpiar
function limpiar() {
  $("#name").val("");
  $("#last_name").val("");
  $("#document_number").val("");
  $("#address").val("");
  $("#phone").val("");
  $("#email").val("");
  $("#id").val("");
  $("#selected_zones_container").empty();
  $("#zone_ids").val("");
}

//funcion mostrar formulario
function mostrarform(flag) {
  limpiar();
  if (flag) {
    $("#listadoregistros").hide();
    $("#formularioregistros").show();
    $("#btnGuardar").prop("disabled", false);
    $("#btnagregar").hide();
  } else {
    $("#listadoregistros").show();
    $("#formularioregistros").hide();
    $("#btnagregar").show();
  }
}

//cancelar form
function cancelarform() {
  limpiar();
  mostrarform(false);
}

//funcion listar
function listar() {
  var zone_id = $('#zone_id').val();
  tabla = $("#tbllistado")
    .dataTable({
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        thousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
      aProcessing: true, //activamos el procedimiento del datatable
      aServerSide: true, //paginacion y filrado realizados por el server
      dom: "Bfrtip", //definimos los elementos del control de la tabla
      buttons: [
        {
          extend: "excelHtml5",
          text: '<i class="fa fa-file-excel-o bg-green"></i> Excel',
          titleAttr: "Exportar a Excel",
          title: "Reporte de Clientes",
          sheetName: "Clientes",
          exportOptions: {
            columns: [1, 2, 3, 4, 5],
          },
        },
        {
          extend: "pdfHtml5",
          text: '<i class="fa fa-file-pdf-o bg-red"></i> PDF',
          titleAttr: "Exportar a PDF",
          title: "Reporte de Clientes",
          //messageTop: "Reporte de usuarios",
          pageSize: "A4",
          //orientation: 'landscape',
          exportOptions: {
            columns: [1, 2, 3, 4, 5],
          },
        },
      ],
      ajax: {
        url: "customers/listar",
        data:{zone_id:zone_id},
        type: "get",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      iDisplayLength: 10, //paginacion
      order: [[0, "desc"]], //ordenar (columna, orden)
    })
    .DataTable();
}
//funcion para guardaryeditar
function guardaryeditar(e) {
  e.preventDefault(); //no se activara la accion predeterminada
  $("#btnGuardar").prop("disabled", true);
  var formData = new FormData($("#formulario")[0]);

  $.ajax({
    url: "customers/guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,

    success: function (datos) {
      var tabla = $("#tbllistado").DataTable();
      Swal.fire({
        title: "Registro",
        text: datos,
        icon: "info",
      }),
        mostrarform(false);
      tabla.ajax.reload();
    },
  });

  limpiar();
}

function mostrar(id) {
  $.post(
    "customers/mostrar",
    { id: id },
    function (data, status) {
      data = JSON.parse(data);
      mostrarform(true);

      $("#name").val(data.name);
      $("#last_name").val(data.last_name);
      $("#document_number").val(data.document_number);
      $("#address").val(data.address);
      $("#phone").val(data.phone);
      $("#email").val(data.email);
      $("#id").val(data.id);
      
      // Limpiar zonas existentes
      $('#selected_zones_container').empty();
      
      // Agregar zonas si existen
      if (data.zones && data.zones.length > 0) {
        data.zones.forEach(zone => {
          const chip = `
            <div class="btn-group" id="zone_chip_${zone.id}">
              <button type="button" class="btn btn-sm btn-outline-primary">${zone.name}</button>
              <button type="button" class="btn btn-sm btn-outline-danger" onclick="removeZone('${zone.id}')">
                <i class="fa fa-times"></i>
              </button>
            </div>
          `;
          $('#selected_zones_container').append(chip);
        });
        updateHiddenZones();
      }
    }
  );
}

//funcion para desactivar
function eliminar(id) {

  $.post(
    "customers/mostrarVentas",
    { id: id },
    function (e) {
      data = JSON.parse(e);
      //  console.log(data.cantidadVentas);
      if (parseInt(data.cantidadVentas) > 0) {
        Swal.fire({
          title: "Error?",
          text: "Este cliente tiene ventas registradas",
          icon: "error",
        });
      } else {
        Swal.fire({
          title: "Eliminar?",
          text: "Esá seguro de eliminar?",
          icon: "warning",
          buttons: {
            cancel: "No, cancelar",
            confirm: "Si, eliminar",
          },
          //buttons: true,
          dangerMode: true,
        }).then((willDelete) => {
          if (willDelete) {
            $.post(
              "customers/eliminar",
              { id: id },
              function (e) {
                Swal.fire(e, "Desactivado!", {
                  icon: "success",
                });
                var tabla = $("#tbllistado").DataTable();
                tabla.ajax.reload();
              }
            );
          }
        });
      }
    }
  );

}
init();
