var tabla;

//funcion que se ejecuta al inicio
function init() {
  mostrarform(false);
  listar();

  $("#formulario").on("submit", function (e) {
    guardaryeditar(e);
  });

  $("#zone_id").change(listar);
}

//funcion limpiar
function limpiar() {
  $("#date").val("");
  $("#topic").val("");
}

//funcion mostrar formulario
function mostrarform(flag) {
  limpiar();
  if (flag) {
    $("#listadoregistros").hide();
    $("#formularioregistros").show();
    $("#btnGuardar").prop("disabled", false);
    $("#btnagregar").hide();
  } else {
    $("#listadoregistros").show();
    $("#formularioregistros").hide();
    $("#btnagregar").show();
  }
}

//cancelar form
function cancelarform() {
  limpiar();
  mostrarform(false);
}

//funcion listar
function listar() {
  var id = $("#id").val();
  var zone_id = $("#zone_id").val();
  tabla = $("#tbllistado")
    .dataTable({
      language: {
        decimal: "",
        emptyTable: "No hay información",
        info: "Mostrando _START_ a _END_ de _TOTAL_ Entradas",
        infoEmpty: "Mostrando 0 to 0 of 0 Entradas",
        infoFiltered: "(Filtrado de _MAX_ total entradas)",
        infoPostFix: "",
        thousands: ",",
        lengthMenu: "Mostrar _MENU_ Entradas",
        loadingRecords: "Cargando...",
        processing: "Procesando...",
        search: "Buscar:",
        zeroRecords: "Sin resultados encontrados",
        paginate: {
          first: "Primero",
          last: "Ultimo",
          next: "Siguiente",
          previous: "Anterior",
        },
      },
      aProcessing: true, //activamos el procedimiento del datatable
      aServerSide: true, //paginacion y filrado realizados por el server
      dom: "Bfrtip", //definimos los elementos del control de la tabla
      buttons: [
        {
          extend: "excelHtml5",
          text: '<i class="fa fa-file-excel-o"></i> Excel',
          titleAttr: "Exportar a Excel",
          title: "Reporte de Reuniones",
          sheetName: "Reuniones",
          exportOptions: {
            columns: [1, 2, 3],
          },
        },
        {
          extend: "pdfHtml5",
          text: '<i class="fa fa-file-pdf-o"></i> PDF',
          titleAttr: "Exportar a PDF",
          title: "Reporte de Reunioes",
          //messageTop: "Reporte de usuarios",
          pageSize: "A4",
          //orientation: 'landscape',
          exportOptions: {
            columns: [1, 2, 3],
          },
        },
      ],
      ajax: {
        url: baseUrl + "attendances/listar",
        data: { id: id, zone_id: zone_id },
        type: "post",
        dataType: "json",
        error: function (e) {
          console.log(e.responseText);
        },
      },
      bDestroy: true,
      iDisplayLength: 20, //paginacion
      order: [[0, "desc"]], //ordenar (columna, orden)
    })
    .DataTable();
}
//funcion para guardaryeditar
function guardaryeditar(e) {
  e.preventDefault(); //no se activara la accion predeterminada
  $("#btnGuardar").prop("disabled", true);
  var formData = new FormData($("#formulario")[0]);

  $.ajax({
    url: "meetings/guardaryeditar",
    type: "POST",
    data: formData,
    contentType: false,
    processData: false,

    success: function (datos) {
      var tabla = $("#tbllistado").DataTable();
      Swal.fire({
        title: "Registro",
        text: datos,
        icon: "info",
        buttons: {
          confirm: "OK",
        },
      }),
        mostrarform(false);
      tabla.ajax.reload();
    },
  });

  limpiar();
}

function mostrar(id) {
  $.post("meetings/mostrar", { id: id }, function (data, status) {
    data = JSON.parse(data);
    mostrarform(true);

    $("#date").val(data.date);
    $("#topic").val(data.topic);
    $("#id").val(data.id);
  });
}

function registrar(id, tipo) {
  $.post(
    baseUrl + "attendances/registrar",
    { id: id, tipo: tipo },
    function (data, status) {
      var tabla = $("#tbllistado").DataTable();
      /* Swal.fire({
            position: "top-end",
            width: 300,
              //title: data,
              html:'<i class="fas fa-lg fa-check text-success"></i>'+' '+data,
              //icon: "success",
              showConfirmButton: false,
              timer: 1500
            }),*/
      tabla.ajax.reload();
    }
  );
}

function registerAll(id, tipo) {
  var txt =
    tipo == "1"
      ? "Está seguro de marcar asistencia para todos ?"
      : "Está seguro de marcar falta para todos ?";
  var tit = tipo == "1" ? "Asistencia" : "Falta";
  Swal.fire({
    title: tit,
    text: txt,
    icon: "warning",
    showCancelButton: true,
    //confirmButtonColor: '#3085d6',
    //cancelButtonColor: '#d33',
    confirmButtonText: "Si, registrar!",
    cancelButtonText: "Cancelar",
  }).then((result) => {
    if (result.isConfirmed) {
      $.post(
        baseUrl + "attendances/register-all",
        { meeting_id: id, tipo: tipo },
        function (e) {
          Swal.fire(e, "Registrado!", "success", {});
          var tabla = $("#tbllistado").DataTable();
          tabla.ajax.reload();
        }
      );
    }
  });
}

// Crea un nuevo objeto Scanner de Instascan con las configuraciones especificadas
var scanner = new Instascan.Scanner({
  continuous: true, // Escaneo continuo
  video: document.getElementById("preview"), // Elemento de video para mostrar la vista previa del escáner
  mirror: false, // No se refleja la imagen en el escáner
  captureImage: false, // No se captura la imagen
  backgroundScan: false, // No se escanea en segundo plano
  refractoryPeriod: 3000, // Período refractario de 5 segundos
  scanPeriod: 5, // Período de escaneo de 5 milisegundos
});

// Agrega un evento 'scan' al escáner que se activa cuando se escanea un código
scanner.addListener("scan", function (content) {
  var id = $("#id").val();

  $.post(
    baseUrl + "attendances/register/qr",
    { document_number: content, id: id },
    function (data) {
      try {
        // Parsear los datos JSON primero
        var response = JSON.parse(data);

        if (response.success) {
          Swal.fire({
            position: "top-end",
            title: response.message,
            text: response.message,
            icon: "success",
            showConfirmButton: false,
            timer: 1500,
          });
        } else {
          Swal.fire({
            title: "Atención",
            text: response.message || "No se encontró ningún socio",
            icon: "warning",
          });
        }
      } catch (error) {
        console.error("Error al parsear JSON:", error);
        console.log("Datos originales:", data);

        Swal.fire({
          title: "Error",
          text: "Error al procesar los datos del socio",
          icon: "error",
        });
      }
    }
  ).fail(function (xhr, status, error) {
    console.error("Error en la petición:", error);

    Swal.fire({
      title: "Error",
      text: "No se pudo procesar el código QR",
      icon: "error",
    });
  });
});

// Función para iniciar la lectura QR
function iniciarLecturaQr() {
  // Configurar el modal
  $("#mdlQRSocio").modal({
    backdrop: "static",
    keyboard: false,
  });
  // Mostrar el modal
  $("#mdlQRSocio").modal("show");
}

// Eventos del modal para manejar la cámara
$("#mdlQRSocio").on("shown.bs.modal", function () {
  // Iniciar la cámara cuando el modal esté completamente visible
  iniciaCamara();
});

$("#mdlQRSocio").on("hidden.bs.modal", function () {
  // Asegurar que la cámara se apague cuando el modal se cierre
  apagaCamara();
});

// Función para iniciar la cámara y comenzar a escanear códigos QR
function iniciaCamara() {
  // Obtiene las cámaras disponibles y comienza a escanear utilizando la última cámara encontrada
  Instascan.Camera.getCameras()
    .then(function (cameras) {
      if (cameras.length > 0) {
        scanner.start(cameras[cameras.length - 1]);
      } else {
        Swal.fire({
          title: "Error",
          text: "No se encontró una cámara disponible",
          icon: "error",
        });
        $("#mdlQRSocio").modal("hide");
      }
    })
    .catch(function (e) {
      console.error(e);
      Swal.fire({
        title: "Error",
        text: "Error al acceder a la cámara: " + e.message,
        icon: "error",
      });
      $("#mdlQRSocio").modal("hide");
    });
}

// Función para detener el escaneo y apagar la cámara
function apagaCamara() {
  try {
    if (scanner) {
      scanner.stop();
    }
  } catch (e) {
    console.error("Error al detener el scanner:", e);
  }
}
init();
