<?php

namespace App\Models;

class User extends Model
{

	private $tableName = 'usuario';

	//metodo insertar registro
	public function insertar($nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $cargo,$zone_id, $login, $clave, $imagen, $permisos)
	{
		$sql = "INSERT INTO $this->tableName (zone_id,nombre,tipo_documento,num_documento,direccion,telefono,email,cargo,login,clave,imagen,condicion) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";

		$arrDataInsert = array($zone_id,$nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $cargo, $login, $clave, $imagen, 1);
		$idusuarionew = $this->getReturnId($sql, $arrDataInsert);

		$num_elementos = 0;
		$sw = true;
		while ($num_elementos < count($permisos)) {

			$sql_detalle = "INSERT INTO usuario_permiso (idusuario,idpermiso) VALUES(?,?)";
			$arrDataPermiso = array($idusuarionew, $permisos[$num_elementos]);
			$this->setData($sql_detalle, $arrDataPermiso) or $sw = false;

			$num_elementos = $num_elementos + 1;
		}
		return $sw;
	}

	public function editar($idusuario, $nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $cargo,$zone_id, $login, $imagen, $permisos)
	{
		$sw = true;
		$sql = "UPDATE $this->tableName SET zone_id=?, nombre=?,tipo_documento=?,num_documento=?,direccion=?,telefono=?,email=?,cargo=?,login=?,imagen=? 
		WHERE idusuario=?";
		$arrDataUpdate = array($zone_id,$nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $cargo, $login, $imagen, $idusuario);
		$this->setData($sql, $arrDataUpdate) or $sw = false;

		//eliminar permisos asignados 
		$sqldel = "DELETE FROM usuario_permiso WHERE idusuario=?";
		$arrDataDel = array($idusuario);
		$this->setData($sqldel, $arrDataDel) or $sw = false;

		$num_elementos = 0;
		while ($num_elementos < count($permisos)) {

			$sql_detalle = "INSERT INTO usuario_permiso (idusuario,idpermiso) VALUES(?,?)";
			$arrDataPermiso = array($idusuario, $permisos[$num_elementos]);
			$this->setData($sql_detalle, $arrDataPermiso) or $sw = false;

			$num_elementos = $num_elementos + 1;
		}
		return $sw;
	}

	public function editarPerfil($idusuario, $nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $login, $clave, $imagen, $descripcion, $biografia)
	{
		$sw = true;
		$sql = "UPDATE $this->tableName SET nombre=?,tipo_documento=?,num_documento=?,direccion=?,telefono=?,email=?,login=?,imagen=?,descripcion=?,biografia=? 
		WHERE idusuario=?";
		$arrDataUpdate = array($nombre, $tipo_documento, $num_documento, $direccion, $telefono, $email, $login, $imagen, $descripcion, $biografia, $idusuario);
		$this->setData($sql, $arrDataUpdate) or $sw = false;
		if (!empty($clave)) {
			//Hash SHA256 para la contraseña
			$clavehash = hash("SHA256", $clave);
			$sql = "UPDATE $this->tableName SET clave=? 
		WHERE idusuario=?";
			$arrDataUpdate = array($clavehash, $idusuario);
			$this->setData($sql, $arrDataUpdate) or $sw = false;
		}
		return $sw;
	}

	public function editar_clave($idusuario, $clave)
	{
		$sql = "UPDATE $this->tableName SET clave=? WHERE idusuario=?";
		$arrData = array($clave, $idusuario);
		return $this->setData($sql, $arrData);
	}
	public function mostrar_clave($idusuario)
	{
		$sql = "SELECT idusuario, clave FROM $this->tableName WHERE idusuario=?";
		$arrData = array($idusuario);
		return  $this->getData($sql, $arrData);
	}
	public function desactivar($idusuario)
	{
		$sql = "UPDATE $this->tableName SET condicion='0' WHERE idusuario=?";
		$arrData = array($idusuario);
		return $this->setData($sql, $arrData);
	}
	public function activar($idusuario)
	{
		$sql = "UPDATE $this->tableName SET condicion='1' WHERE idusuario=?";
		$arrData = array($idusuario);
		return $this->setData($sql, $arrData);
	}

	//metodo para mostrar registros
	public function mostrar(string $idusuario)
	{
		$sql = "SELECT * FROM $this->tableName WHERE idusuario=?";
		$arrData = array($idusuario);
		return  $this->getData($sql, $arrData);
	}

	//listar registros
public function listar()
{
    $sql = "SELECT u.*, 
           IFNULL(z.name, '-') AS barrio 
           FROM $this->tableName u 
           LEFT JOIN zones z ON u.zone_id=z.id";
    
    return $this->getDataAll($sql);
}

	//metodo para listar permmisos marcados de un usuario especifico
	public function listarmarcados(string $idusuario)
	{
		$sql = "SELECT * FROM usuario_permiso WHERE idusuario='$idusuario'";
		return  $this->getDataAll($sql);
	}


	public function verificar(string $login, string $clave)
	{
		$sql = "SELECT idusuario,zone_id,nombre,tipo_documento,num_documento,telefono,email,cargo,imagen,direccion,login FROM $this->tableName WHERE login=? AND clave=? AND condicion='1'";
		$arrData = array($login, $clave);
		return  $this->getData($sql, $arrData);
	}
}
