<?php 
namespace App\Models;
//incluir la conexion de base de datos
//require_once "Connect.php";
class Reading extends Model{

    private $tableName='meter_readings';
	private $tablePayments = 'payments';


	//metodo insertar regiustro
	public function insertar($meter_id, $previus_reading, $last_reading,$consumption, $total_cost,$type,$date,$client_id) {
		
		$sw=true;
		$sql = "INSERT INTO $this->tableName (meter_id, previus_reading, last_reading, consumption, total_cost,status,type) VALUES (?,?,?,?,?,?,?)";
		$arrData = array($meter_id, $previus_reading, $last_reading, $consumption, $total_cost, '0',$type);
		$readinId= $this->getReturnId($sql, $arrData);
		$uuid = 'PAYUID_' . bin2hex(random_bytes(16)); 
		$sql = "INSERT INTO $this->tablePayments (uuid,client_id,date,amount,reference_id,reference_table,description) VALUES (?,?,?,?,?,?,?)";
        $arrData = array($uuid,$client_id, $date, $total_cost, $readinId, 'meter_readings','Pago por consumo de agua');
        $this->setData($sql, $arrData) ||$sw=false;
		return $sw;
	
	}

	
    public function editar($id, $meter_id, $previus_reading, $last_reading, $consumption, $total_cost,$type){
		$sw=true;
        $sql="UPDATE $this->tableName SET meter_id=?,previus_reading=?,last_reading=?,consumption=?, total_cost=?,type=? WHERE id=?";
        $arrData = array($meter_id,$previus_reading,$last_reading, $consumption,$total_cost,$type,$id);
        $this->setData($sql,$arrData)||$sw=false;

		$sql="SELECT id FROM $this->tablePayments WHERE reference_id=? AND reference_table=?";
		$arrData = array($id,'meter_readings');
		$payment = $this->getData($sql,$arrData);
		
		$sql = "UPDATE $this->tablePayments SET amount = ? WHERE id =?";
		$arrData = array($total_cost,$payment['id']);
		$this->setData($sql,$arrData)||$sw=false;
		return $sw;

    }


	public function activar($id){
		$sql="UPDATE $this->tableName SET estado=?,condicion=? WHERE id=?";
		$arrData = array('En proceso','0',$id);
		return $this->setData($sql,$arrData);
	}

	//metodo para mostrar registros
	public function mostrar($id){
		$sql="SELECT * FROM $this->tableName WHERE id=?";
		$arrData = array($id);
		return  $this->getData($sql,$arrData); 
	}

	//listar registros
public function listar($zone_id)
{
    $sql = "SELECT mr.*, m.series, m.zone_id, z.name as zone_name 
           FROM $this->tableName mr 
           INNER JOIN meters m ON mr.meter_id = m.id 
           LEFT JOIN zones z ON m.zone_id = z.id";
    
    if (!empty($zone_id)) {
        $sql .= " WHERE m.zone_id = " . (int)$zone_id; // Seguro para IDs numéricos
    }
    
    return $this->getDataAll($sql);
}

	public function listarLecturasPendientes($meter_id)
	{
		$sql = "SELECT mr.*, m.series FROM $this->tableName mr INNER JOIN meters m ON mr.meter_id=m.id WHERE mr.meter_id='$meter_id' AND mr.status='0'";
		return  $this->getDataAll($sql);
	}

		public function searchMeter($codigo) {
		$sql = "SELECT m.*, 
					   CONCAT(c.name, ' ', c.last_name) AS client,c.document_number AS cedula,c.id AS client_id, 
					   COALESCE((SELECT last_reading 
								 FROM meter_readings 
								 WHERE meter_id = m.id 
								 ORDER BY id DESC 
								 LIMIT 1), 0) AS last_reading
				FROM meters m
				INNER JOIN clients c ON m.client_id = c.id WHERE m.series = ?";
	
		//return $this->getDataAll($sql); 
		$arrData = array($codigo);
		return  $this->getData($sql,$arrData); 
	}


}

