<?php

namespace App\Models;

use Exception;

//incluir la conexion de base de datos

class Payment extends Model
{

    private $tablePayments = 'payments';
    private $tablePay = 'pay';
    private $tableMeterReadings = 'meter_readings';


    //metodo insertar registro
    public function insertar($client_id, $date, $totalAmount, $type, $transfer_number, $payment_id, $amount_cost)
    {

        try {
            $this->beginTransaction();
            // Insertar venta
            $idPay = $this->registrarPago($client_id, 'Pago de obligaciones', $totalAmount, $date, $type, $transfer_number);

            //Actualizar lecturas
            $this->insertarDetallePago($idPay, $payment_id, $amount_cost);
            //$this->actualizarLectura($reference_id);

            $this->commit();
            return $idPay;
        } catch (Exception $e) {
            $this->rollBack();
            // Registra o imprime un mensaje de error descriptivo
            error_log("Error al insertar pago: " . $e->getMessage());
            //return false;
            echo $e->getMessage();
        }
    }

    //registro de pagos
    private function registrarPago($client_id, $concept, $amount, $date, $type, $transfer_number)
    {

        $sql = "INSERT INTO $this->tablePay (client_id,concept,amount,date,type,transfer_number) VALUES (?,?,?,?,?,?)";
        $arrData = array($client_id, $concept, $amount, $date, $type, $transfer_number);
        return $this->getReturnId($sql, $arrData);
    }

    //INSERTAR PAGO
    /*public function insertarPago($client_id, $date, $amount, $reference_id, $reference_table, $description)
    {

        $sql = "INSERT INTO payments (client_id,date,amount,reference_id,reference_table,description) VALUES (?,?,?,?,?,?)";
        $arrData = array($client_id, $date, $amount, $reference_id, $reference_table, $description);
        return $this->setData($sql, $arrData);
    }*/
    public function insertarPagosBatch(array $pagosData)
    {
        $sql = "INSERT INTO payments (client_id, date, amount, reference_id, reference_table, description) 
            VALUES ";

        $placeholders = [];
        $values = [];

        foreach ($pagosData as $data) {
            $placeholders[] = "(?, ?, ?, ?, ?, ?)";
            $values[] = $data['client_id'];
            $values[] = $data['date'];
            $values[] = $data['amount'];
            $values[] = $data['reference_id'];
            $values[] = $data['reference_table'];
            $values[] = $data['description'];
        }

        $sql .= implode(", ", $placeholders);
        return $this->setData($sql, $values);
    }
    // FUNCION PARA REGISTRAR DETALLE DE PAGOS
    private function insertarDetallePago($idPay, $payment_id, $amount)
    {
        $sw = true;

        foreach ($payment_id as $key => $idArt) {

            $sqlDetalle = "INSERT INTO payment_details (pay_id, payment_id, amount) VALUES (?, ?, ?)";
            $arrDataDet = array($idPay, $idArt, $amount[$key]);

            if (!$this->setData($sqlDetalle, $arrDataDet)) {
                $sw = false;
            }

            $sql = "UPDATE payments SET status = ? WHERE id=?";
            $arrData = array('1', $idArt);
            if (!$this->setData($sql, $arrData)) {
                $sw = false;
            }
        }

        return $sw;
    }


    private function actualizarLectura($reading_ids)
    {
        $sw = true;
        foreach ($reading_ids as $idArt) {
            $sqlDetalle = "UPDATE $this->tableMeterReadings SET status=? WHERE id=?";
            $arrDataDet = array('1', $idArt);

            if (!$this->setData($sqlDetalle, $arrDataDet)) {
                $sw = false;
            }
        }
        return $sw;
    }




    //implementar un metodo para mostrar los datos de unregistro a modificar
    public function mostrar($idventa)
    {
        $sql = "SELECT v.idventa,DATE(v.type) as fecha,v.meter_id,v.total_descuento,p.nombre as cliente,p.tipo_documento AS tipoDocumentoCliente,p.num_documento AS numDocumentoCliente,p.direccion AS direccionCliente,u.date,u.nombre as usuario, v.amount,f.establecimiento,f.punto_emision,f.numero_factura,f.xml,v.total_venta,v.impuesto,v.tipo_pago,v.num_transac,v.estado,v.transfer_number,v.transfer_number12,v.transfer_number0 FROM $this->tablePayments v INNER JOIN clients p ON v.meter_id=p.idpersona INNER JOIN usuario u ON v.date=u.date INNER JOIN factura f ON v.idventa=f.id_operacion AND f.tipo_operacion='Venta' WHERE v.idventa=?";
        $arrData = array($idventa);
        return  $this->getData($sql, $arrData);
    }

    public function anular($id)
    {
        $sw = true;
        //obtener la lista de pagos 
        $sql = "SELECT * FROM payment_details WHERE pay_id=$id";
        $details = $this->getDataAll($sql);

        foreach ($details as $detail) {
            // Actualizar el estado de las lecturas de medidor a '0'
            $sql = "UPDATE payments SET status = ? WHERE id = ?";
            $arrData = ['0', $detail['payment_id']];

            if (!$this->setData($sql, $arrData)) {
                $sw = false;
            }
        }
        // Actualizar el estado del pago a '0'
        $sql = "UPDATE $this->tablePay SET status = ? WHERE id = ?";
        $arrData = ['0', $id];

        if (!$this->setData($sql, $arrData)) {
            $sw = false;
        }
        return $sw;
    }


    public function listarDetalle($idventa)
    {
        $sql = "SELECT dv.idventa,dv.idarticulo,a.nombre,dv.cantidad,dv.precio,dv.descuento,(dv.cantidad*dv.precio-dv.descuento) as transfer_number, v.total_venta FROM detalle_venta dv INNER JOIN articulo a ON dv.idarticulo=a.idarticulo INNER JOIN venta v ON v.idventa=dv.idventa WHERE dv.idventa='$idventa'";
        return  $this->getDataAll($sql);
    }

    //listar registros
    public function listar()
    {
        $sql = "SELECT p.*,CONCAT(c.name, ' ', c.last_name) AS client FROM $this->tablePay p INNER JOIN clients c ON p.client_id=c.id ORDER BY p.id DESC";
        return  $this->getDataAll($sql);
    }


    public function ventacabecera($id)
    {
        $sql = "SELECT v.id,DATE(v.date) as fecha,v.amount,v.type,v.status,p.name as cliente,p.document_number AS numDocumentoCliente,p.address AS direccionCliente,p.email AS emailCliente,p.phone AS telefonoCliente,v.transfer_number FROM $this->tablePay v INNER JOIN clients p ON v.client_id=p.id  WHERE v.id=?";
        $arrData = array($id);
        return  $this->getData($sql, $arrData);
    }

    public function reciboCabecera($id)
    {
        $sql = "SELECT hp.interes,hp.capital,hp.mora,hp.total AS totalPago,hp.descripcion,hp.descuento, v.idventa,DATE(hp.type) as fecha,p.nombre as cliente,p.tipo_documento AS tipoDocumentoCliente,p.num_documento AS numDocumentoCliente,p.direccion AS direccionCliente,p.email AS emailCliente,p.telefono AS telefonoCliente,u.nombre as usuario, v.amount,f.establecimiento,f.punto_emision,f.numero_factura FROM historial_pagos hp INNER JOIN venta_credito vc ON hp.id_credito=vc.id INNER JOIN venta v ON vc.idVenta=v.idventa INNER JOIN persona p ON v.meter_id=p.idpersona INNER JOIN usuario u ON v.date=u.date INNER JOIN factura f ON v.idventa=f.id_operacion AND f.tipo_operacion='Venta' WHERE hp.id=?";
        $arrData = array($id);
        return  $this->getData($sql, $arrData);
    }

    public function ventadetalles($idventa)
    {
        $sql = "SELECT p.date, p.description, p.amount FROM payment_details d INNER JOIN payments p ON d.payment_id=p.id WHERE d.pay_id='$idventa'";
        return  $this->getDataAll($sql);
    }

    public function pagosPendientes($client_id)
    {
        if ($client_id) {
            $sql = "SELECT id,DATE(date) AS date, amount,description FROM $this->tablePayments WHERE client_id =$client_id AND status='0'";
            return  $this->getDataAll($sql);
        } else {
            return [];
        }
    }

    public function mostrarUltimaFactura($table, $id)
    {
        $sql = "SELECT p.id, 
        p.uuid,
                   DATE(p.date) AS fecha_pago,
                   p.amount AS monto,
                   p.description AS descripcion,
                   p.reference_id,
                   p.status AS estado,
                   mr.created_at AS fecha_lectura,
                   mr.consumption AS consumo,
                   mr.previus_reading AS lectura_anterior,
                   mr.last_reading AS lectura_actual,
                   mr.type AS tipo_lectura,
                   CONCAT(c.name,' ',c.last_name) as cliente,c.document_number AS numDocumentoCliente,c.address AS direccionCliente,c.email AS emailCliente,c.phone AS telefonoCliente
            FROM payments p
            INNER JOIN clients c ON p.client_id = c.id
            INNER JOIN meter_readings mr ON 
                p.reference_id = mr.id 
                AND p.reference_table = 'meter_readings'
            WHERE p.reference_table = ? AND mr.meter_id = ? ORDER BY id DESC LIMIT 1";
        $arrData = array($table, $id);
        return $this->getData($sql, $arrData);
    }

    public function mostrarLecturaMedidor($id)
    {
        $sql = "SELECT * FROM meter_readings WHERE id = ?";
        $arrData = array($id);
        return $this->getData($sql, $arrData);
    }

    public function totalPagoPendienteAgua($table, $client_id, $meter_id)
    {
        $sql = "SELECT IFNULL(SUM(p.amount), 0) AS total FROM payments p INNER JOIN meter_readings mr ON 
                p.reference_id = mr.id 
                AND p.reference_table = 'meter_readings' WHERE p.reference_table = ? AND p.status = 0 AND p.client_id=? AND mr.meter_id = ?";
        $arrData = array($table, $client_id, $meter_id);
        $result = $this->getData($sql, $arrData);
        return $result['total'];
    }

    public function totalPagoPendienteMulta($table, $client_id)
    {
        $sql = "SELECT IFNULL(SUM(p.amount), 0) AS total FROM payments p INNER JOIN client_meeting mr ON 
                p.reference_id = mr.id 
                AND p.reference_table = 'client_meeting' WHERE p.reference_table = ? AND p.status = 0 AND p.client_id=?";
        $arrData = array($table, $client_id);
        $result = $this->getData($sql, $arrData);
        return $result['total'];
    }

    public function listarFacturas($client_id, $meter_id)
    {
        if (empty($client_id)) {
            return [];
        }

        $sql = "SELECT p.id,
                   p.uuid, 
                   DATE(p.date) AS fecha_pago,
                   p.amount AS monto,
                   p.description AS descripcion,
                   p.reference_id,
                   p.status AS estado,
                   mr.created_at AS fecha_lectura,
                   mr.consumption AS consumo,
                   mr.previus_reading AS lectura_anterior,
                   mr.last_reading AS lectura_actual,
                   mr.type AS tipo_lectura
            FROM payments p
            INNER JOIN meter_readings mr ON 
                p.reference_id = mr.id 
                AND p.reference_table = 'meter_readings'
            WHERE p.client_id = '$client_id' AND mr.meter_id = '$meter_id'
            ORDER BY p.date DESC";

        return $this->getDataAll($sql);
    }

    public function listarFacturaReuniones($client_id)
    {
        if (empty($client_id)) {
            return [];
        }

        $sql = "SELECT p.id,
                   p.uuid, 
                   DATE(p.date) AS fecha_pago,
                   p.amount AS monto,
                   p.description AS descripcion,
                   p.reference_id,
                   p.status AS estado_pago,
                   cm.created_at AS fecha_asistencia,
                   cm.attendance AS estado_asistencia,
                   cm.fine AS multa,
                   cm.fine_status AS estado_multa,
                   m.date AS fecha_reunion,
                   m.topic AS tema_tratado,
                   m.status AS estado_reunion
            FROM payments p
            INNER JOIN client_meeting cm ON 
                p.reference_id = cm.id 
                AND p.reference_table = 'client_meeting'
                INNER JOIN meetings m ON m.id = cm.meeting_id
            WHERE p.client_id = '$client_id'
            ORDER BY p.date DESC";

        return $this->getDataAll($sql);
    }

    public function imprimirFactura($id)
    {


        $sql = "SELECT p.id, 
                   DATE(p.date) AS fecha_pago,
                   p.amount AS monto,
                   p.description AS descripcion,
                   p.reference_id,
                   p.status AS estado,
                   mr.created_at AS fecha_lectura,
                   mr.consumption AS consumo,
                   mr.previus_reading AS lectura_anterior,
                   mr.last_reading AS lectura_actual,
                   mr.type AS tipo_lectura,
                   CONCAT(c.name,' ',c.last_name) as cliente,c.document_number AS numDocumentoCliente,c.address AS direccionCliente,c.email AS emailCliente,c.phone AS telefonoCliente
            FROM payments p
            INNER JOIN clients c ON p.client_id = c.id
            INNER JOIN meter_readings mr ON 
                p.reference_id = mr.id 
                AND p.reference_table = 'meter_readings'
            WHERE p.uuid = ?";

        $arrData = array($id);
        return $this->getData($sql, $arrData);
    }
}
