<?php

namespace App\Models;

class Consult extends Model
{

public function pagosfechacliente($fecha_inicio, $fecha_fin, $client_id, $zone_id/*, $type*/)
{
    // Base de la consulta SQL
    $sql = "SELECT p.amount, DATE(p.date) as fecha, p.type, s.name as cliente, 
                   GROUP_CONCAT(z.name SEPARATOR ', ') AS barrios
            FROM payments p
            INNER JOIN clients s ON p.client_id = s.id
            LEFT JOIN client_zones cz ON s.id = cz.client_id
            LEFT JOIN zones z ON cz.zone_id = z.id
            WHERE DATE(p.date) >= '$fecha_inicio' AND DATE(p.date) <= '$fecha_fin'";

    // Añadir condiciones según los parámetros
    if (!empty($client_id)) {
        $sql .= " AND p.client_id = '$client_id'";
    }

    if (!empty($zone_id)) {
        $sql .= " AND z.id = '$zone_id'";
    }

    /*if (!empty($type)) {
        $sql .= " AND p.type = '$type'";
    }*/

    // Agrupar por pago para evitar duplicados
    $sql .= " GROUP BY p.id";

    // Ordenar por ID descendente
    $sql .= " ORDER BY p.id DESC";

    // Ejecutar y retornar los resultados
    return $this->getDataAll($sql);
}



  public function ingresosultimos_12meses()
  {
    $sql = "SELECT DATE_FORMAT(date, '%M') AS fecha, SUM(amount) AS total 
    FROM incomes  
    GROUP BY DATE_FORMAT(date, '%M') 
    ORDER BY MONTH(date) DESC 
    LIMIT 0, 12;";
    return  $this->getDataAll($sql);
  }


  public function egresosultimos_12meses()
  {
    $sql = "SELECT DATE_FORMAT(date, '%M') AS fecha, SUM(amount) AS total 
    FROM expenses  
    GROUP BY DATE_FORMAT(date, '%M') 
    ORDER BY MONTH(date) DESC 
    LIMIT 0, 12;";
    return  $this->getDataAll($sql);
  }


  public function cantidadclientes()
  {
    $sql = "SELECT COUNT(*) totalc FROM clients";
    return  $this->getDataAll($sql);
  }

  public function cantidadMedidores()
  {
    $sql = "SELECT COUNT(*) totalm FROM meters";
    return  $this->getDataAll($sql);
  }


  public function totalIncomes()
  {
    $sql = "SELECT IFNULL(SUM(amount), 0) as total_income 
            FROM incomes";
    return $this->getDataAll($sql);
  }

  public function totalExpenses()
  {
    $sql = "SELECT COALESCE(SUM(amount), 0) as total_expense 
FROM expenses";
    return $this->getDataAll($sql);
  }
}
