<?php

namespace App\Middleware;

class AuthMiddleware
{
    public function handle($next)
    {
        // Iniciar sesión si aún no ha sido iniciada
        if (session_status() === PHP_SESSION_NONE) {
            session_start(); 
        }

        // Verificar si el usuario está autenticado
        if (!isset($_SESSION['idusuario'])) {
            // Permitir acceso a la página de login o a otras rutas públicas si existen
            $allowedRoutes = ['/login', '/register']; // Añade aquí las rutas públicas que quieras permitir
            if (!in_array($_SERVER['REQUEST_URI'], $allowedRoutes)) {
                // Si el usuario no está autenticado, redirigir a la página de inicio de sesión
                header("Location: /login");
                exit();
            }
        }

        // Continuar con la ejecución del callback/controlador si está autenticado
        return $next(); 
    }
}
