<?php

namespace App\Controllers;

use App\Models\Client;
use App\Models\Company;
use App\Models\Consult;
use App\Models\Meter;
use App\Models\Payment;
use Lib\qrcode\QRcode;
use Lib\fpdf186\Fpdf;

class ReportController extends Controller
{

  private $consult;

  public function __construct()
  {
    $this->consult = new Consult();
  }

  public function index()
  {
    return $this->view('reports.payments-date', ['title' => 'Reporte de pagos por fecha']);
  }

  public function pagosfechacliente()
  {
    function numeroFactura($numero)
    {
      $numero_factura = str_pad($numero, 9, '0', STR_PAD_LEFT);
      return  $numero_factura;
    }

    $fecha_inicio = $_REQUEST["fecha_inicio"];
    $fecha_fin = $_REQUEST["fecha_fin"];
    $client_id = $_REQUEST["client_id"];
    $meter_id = $_REQUEST["meter_id"];
    $zone_id = $_REQUEST["zone_id"];
    $type = $_REQUEST["type"];


    $rspta = $this->consult->pagosfechacliente($fecha_inicio, $fecha_fin, $client_id, $meter_id, $zone_id, $type);
    $data = array();
    $item = 1;
    foreach ($rspta as $reg) {

      $data[] = array(
        "0" => $item,
        "1" => $reg['fecha'],
        "2" => $reg['series'],
        "3" => $reg['amount'],
        "4" => $reg['type'],
        "5" => $reg['cliente'],
        "6" => $reg['barrio'],
      );
      $item++;
    }
    $results = array(
      "sEcho" => 1, //info para datatables
      "iTotalRecords" => count($data), //enviamos el total de registros al datatable
      "iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
      "aaData" => $data
    );
    return json_encode($results);
  }

  public function mostrarTicket($id)
  {

    //return $id;
    $venta = new Payment();

    //en el objeto $rspta obtenemos los valores devueltos del metodo ventacabecera del modelo
    $rspta = $venta->ventacabecera($id);

    $documentoCliente = 'CEDULA';

    $nombreComprobante = 'VOUCHER';

    $numero_factura = str_pad($rspta['id'], 9, '0', STR_PAD_LEFT);
    //datos de la empresa

    $cnegocio = new Company();
    $rsptan = $cnegocio->mostrar(1);
    $regn = $rsptan;
    $empresa = $regn['nombre'];
    $ndocumento = $regn['ndocumento'];
    $documento = $regn['documento'];
    $direccion = $regn['direccion'];
    $telefono = $regn['telefono'];

    $new_simbolo = '$';

    $pdf = new Fpdf($orientation = 'P', $unit = 'mm', array(80, 350));
    $pdf->AddPage();
    $pdf->SetFont('Arial', 'B', 11);    //Letra Arial, negrita (Bold), tam. 20
    $textypos = 5;
    $pdf->setY(2);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos,  mb_convert_encoding($empresa, 'ISO-8859-1', 'UTF-8'), 0, 0, 'C');
    $pdf->SetFont('Arial', '', 9);
    $pdf->setY(7);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding($ndocumento . ": " . $documento, 'ISO-8859-1', 'UTF-8'), 0, 0, 'C');
    $pdf->setY(10);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding("Direc: " . $direccion, 'ISO-8859-1', 'UTF-8'), 0, 0, 'C');
    $pdf->setY(13);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding("Telf: " . $telefono, 'ISO-8859-1', 'UTF-8'), 0, 0, 'C');

    $pdf->setY(22);
    $pdf->setX(3);
    $pdf->SetFont('Arial', '', 8);
    $pdf->Cell(72, $textypos, mb_convert_encoding("Fecha: " . $rspta['fecha'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $pdf->setY(25);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding("Cliente: " . $rspta['cliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $pdf->setY(28);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding($documentoCliente . ": " . $rspta['numDocumentoCliente'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $pdf->setY(34);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding("Atendió: " . $_SESSION['nombre'], 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');
    $pdf->setY(38);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos, mb_convert_encoding(strtoupper($nombreComprobante) . " N°: "  . $numero_factura, 'ISO-8859-1', 'UTF-8'), 0, 0, 'L');


    $pdf->SetFont('Arial', '', 8);    //Letra Arial, negrita (Bold), tam. 20
    $textypos += 6;
    $pdf->setX(3);

    $pdf->Ln(10);

    //SI ESTA ANULADO LA VENTA
    $status = $rspta['status'];
    if (!$status) {
      $pdf->SetFont('Helvetica', 'B', 30);
      $pdf->SetTextColor(245, 183, 177);
      $pdf->setX(12);
      $pdf->Cell(80, 20, strtoupper('ANULADO'));
      $pdf->SetTextColor(0, 0, 0);
    }

    //COLUMNAS
    $pdf->SetFont('Arial', 'b', 7);
    $pdf->setX(3);
    $pdf->Cell(39, 4, 'SERVICIO', 0, 0, 'L');

    $pdf->setX(60);
    $pdf->Cell(15, 4, 'TOTAL', 0, 0, 'C');
    $pdf->Ln(5);
    $pdf->setX(3);
    $pdf->Cell(72, 0, '', 'T');
    $pdf->Ln(2);

    $total = 0;

    $rsptad = $venta->ventadetalles($id);
    foreach ($rsptad as $res) {
      $pdf->SetFont('Helvetica', '', 7);
      $pdf->setX(3);
      $pdf->MultiCell(40, 5, mb_convert_encoding($res['description'], 'ISO-8859-1', 'UTF-8'), 0, 'L');

      $pdf->setX(60);
      $pdf->Cell(15, -5, number_format(round($res['amount'], 2), 2, '.', ','), 0, 0, 'R');

      $total += round($res['amount'], 2);
    }

    $pdf->setX(3);
    $pdf->Cell(72, 0, '', 'T');

    $pdf->setX(3);
    $pdf->Cell(25, 5, 'TOTAL', 0);
    $pdf->Cell(20, 5, '', 0);
    $pdf->setX(60);
    $pdf->Cell(15, 5, $new_simbolo . ' ' . number_format($total, 2, '.', ' ,'), 0, 0, 'R');

    $pdf->SetFont('Arial', 'B', 8);
    $pdf->setX(3);
    $pdf->Cell(54, $textypos + 20, mb_convert_encoding('Tipo de pago: ' . $rspta['type'], 'ISO-8859-1', 'UTF-8'));
    $pdf->Ln(3);


    $pdf->SetFont('Arial', '', 8);
    $pdf->setX(3);
    $pdf->Cell(72, $textypos + 25, mb_convert_encoding('GRACIAS POR SU PREFERENCIA ', 'ISO-8859-1', 'UTF-8') . "\n", 0, 0, 'C');

    //SALIDA DEL ARCHIVO
    $pdf->Output($nombreComprobante . '_'  . $numero_factura . '.pdf', 'i');
    exit;
  }


  public function mostrarQr($code)
  {
    $pdf = new Fpdf('P', 'mm', array(85, 100)); // Tamaño optimizado
    $pdf->AddPage();
    $pdf->SetMargins(3, 3, 3);

    // === ENCABEZADO SIMPLE ===
    $pdf->SetFillColor(52, 73, 94); // Azul gris profesional
    $pdf->Rect(0, 0, 85, 18, 'F');

    // Título
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetXY(5, 6);
    $pdf->Cell(75, 6, mb_convert_encoding("CÓDIGO QR MEDIDOR", 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    // === CÓDIGO DEL MEDIDOR ===
    $pdf->SetTextColor(33, 37, 41);
    $pdf->SetFillColor(248, 249, 250);
    $pdf->Rect(10, 22, 65, 12, 'F');

    // Borde sutil
    $pdf->SetDrawColor(220, 220, 220);
    $pdf->SetLineWidth(0.5);
    $pdf->Rect(10, 22, 65, 12);

    $pdf->SetFont('Arial', 'B', 14);
    $pdf->SetXY(10, 26);
    $pdf->Cell(65, 6, $code, 0, 1, 'C');

    // === CÓDIGO QR ===
    $qrcode = new QRcode($code, 'H'); // Nivel de error alto

    // Contenedor del QR
    $pdf->SetFillColor(255, 255, 255);
    $pdf->Rect(17, 40, 51, 51, 'F');

    // Borde del QR
    $pdf->SetDrawColor(52, 73, 94);
    $pdf->SetLineWidth(1);
    $pdf->Rect(17, 40, 51, 51);

    // Generar QR centrado
    $x_qr = 20;
    $y_qr = 43;
    $size_qr = 45;
    $background_qr = array(255, 255, 255);
    $color_qr = array(0, 0, 0);
    $qrcode->displayFPDF($pdf, $x_qr, $y_qr, $size_qr, $background_qr, $color_qr);

    // === FECHA DE GENERACIÓN ===
    $pdf->SetTextColor(108, 117, 125);
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetXY(5, 95);
    $pdf->Cell(75, 3, mb_convert_encoding("Generado: " . date('d/m/Y H:i'), 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    // Salida del archivo
    $pdf->Output('qr_medidor_' . $code . '.pdf', 'I');
    exit;
  }

  // Versión aún más minimalista
  public function mostrarQrMinimal($code)
  {
    $pdf = new Fpdf('P', 'mm', array(70, 85));
    $pdf->AddPage();
    $pdf->SetMargins(2, 2, 2);

    // Título simple
    $pdf->SetTextColor(33, 37, 41);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetXY(5, 5);
    $pdf->Cell(60, 5, mb_convert_encoding("MEDIDOR QR", 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    // Código
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetXY(5, 12);
    $pdf->Cell(60, 6, $code, 0, 1, 'C');

    // Línea separadora
    $pdf->SetDrawColor(200, 200, 200);
    $pdf->Line(10, 20, 60, 20);

    // QR simple
    $qrcode = new QRcode($code, 'M');

    // Fondo blanco
    $pdf->SetFillColor(255, 255, 255);
    $pdf->Rect(10, 25, 50, 50, 'F');

    // QR centrado
    $qrcode->displayFPDF($pdf, 12, 27, 46, array(255, 255, 255), array(0, 0, 0));

    // Fecha pequeña
    $pdf->SetFont('Arial', '', 7);
    $pdf->SetTextColor(150, 150, 150);
    $pdf->SetXY(5, 78);
    $pdf->Cell(60, 3, date('d/m/Y'), 0, 1, 'C');

    $pdf->Output('qr_minimal_' . $code . '.pdf', 'I');
    exit;
  }

  // Versión cuadrada compacta
  public function mostrarQrCuadrado($code)
  {
    $pdf = new Fpdf('P', 'mm', array(65, 65)); // Formato cuadrado
    $pdf->AddPage();
    $pdf->SetMargins(2, 2, 2);

    // Solo el código en la parte superior
    $pdf->SetTextColor(0, 0, 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetXY(2, 3);
    $pdf->Cell(61, 5, $code, 0, 1, 'C');

    // QR que ocupa casi todo el espacio
    $qrcode = new QRcode($code, 'M');

    // Generar QR grande
    $qrcode->displayFPDF($pdf, 7, 12, 51, array(255, 255, 255), array(0, 0, 0));

    $pdf->Output('qr_cuadrado_' . $code . '.pdf', 'I');
    exit;
  }

  // Versión solo QR (máxima simplicidad)
  public function mostrarQrSolo($code)
  {
    $pdf = new Fpdf('P', 'mm', array(55, 55)); // Solo QR
    $pdf->AddPage();
    $pdf->SetMargins(1, 1, 1);

    // Solo el QR, sin texto adicional
    $qrcode = new QRcode($code, 'H'); // Máxima calidad

    // QR que ocupa todo el espacio disponible
    $qrcode->displayFPDF($pdf, 2, 2, 51, array(255, 255, 255), array(0, 0, 0));

    $pdf->Output('qr_solo_' . $code . '.pdf', 'I');
    exit;
  }

  public function generarQrList()
  {
    $meter = new Meter();
    $meterData = $meter->listar();

    // Configurar PDF en A4 horizontal (para mejor aprovechamiento del espacio)
    $pdf = new Fpdf('L', 'mm', 'A4');
    $pdf->AddPage();
    $pdf->SetMargins(10, 10, 10);
    $pdf->SetAutoPageBreak(false);

    // Tamaño de cada tarjeta QR (ajustable)
    $cardWidth = 65;
    $cardHeight = 65;

    // Espaciado entre tarjetas
    $padding = 5;

    // Calcular cuántas tarjetas caben por fila y columna
    $maxX = floor(($pdf->GetPageWidth() - 20) / ($cardWidth + $padding));
    $maxY = floor(($pdf->GetPageHeight() - 20) / ($cardHeight + $padding));

    $x = 10;
    $y = 10;
    $count = 0;

    foreach ($meterData as $meter) {
      if ($count > 0 && $count % ($maxX * $maxY) == 0) {
        $pdf->AddPage(); // Nueva página cuando se llena la actual
        $x = 10;
        $y = 10;
      }

      // Dibujar borde de la tarjeta (opcional)
      $pdf->Rect($x, $y, $cardWidth, $cardHeight);

      // Texto con la serie
      $pdf->SetTextColor(0, 0, 0);
      $pdf->SetFont('Arial', 'B', 10);
      $pdf->SetXY($x, $y + 3);
      $pdf->Cell($cardWidth, 5, $meter['series'], 0, 0, 'C');

      // Generar QR
      $qrcode = new QRcode($meter['series'], 'M');
      $qrSize = 45; // Tamaño del QR
      $qrX = $x + ($cardWidth - $qrSize) / 2;
      $qrY = $y + 15;

      $qrcode->displayFPDF($pdf, $qrX, $qrY, $qrSize, array(255, 255, 255), array(0, 0, 0));

      // Mover posición para el siguiente QR
      $x += $cardWidth + $padding;
      if ($x + $cardWidth > $pdf->GetPageWidth() - 10) {
        $x = 10;
        $y += $cardHeight + $padding;
      }

      $count++;
    }

    $pdf->Output('lista_qr.pdf', 'I');
    exit;
  }

  public function imprimirFactura($uuid)
  {
    $venta = new Payment();
    $rspta = $venta->imprimirFactura($uuid);

    // Datos de la empresa
    $cnegocio = new Company();
    $rsptan = $cnegocio->mostrar(1);
    $regn = $rsptan;

    // Configuración del PDF (Tamaño carta)
    $pdf = new Fpdf('P', 'mm', 'a4');
    $pdf->AddPage();
    $pdf->SetAutoPageBreak(true, 20);

    // Paleta de colores minimalista y profesional
    $colorPrimario = array(45, 52, 62);      // Azul oscuro profesional
    $colorSecundario = array(120, 130, 140); // Gris neutro
    $colorAcento = array(74, 144, 226);      // Azul acento
    $colorExito = array(39, 174, 96);        // Verde elegante
    $colorAlerta = array(231, 76, 60);       // Rojo elegante
    $colorFondo = array(248, 249, 250);      // Gris muy claro

    // === HEADER CON LOGO ===
    $pdf->SetFillColor($colorFondo[0], $colorFondo[1], $colorFondo[2]);
    $pdf->Rect(0, 0, 210, 45, 'F');

    // Logo de la empresa (ajusta la ruta según tu estructura)
    $logoPath = 'assets/img/company/' . $regn['logo']; // Cambia por la ruta real de tu logo
    if (file_exists($logoPath)) {
      $pdf->Image($logoPath, 15, 10, 25, 25); // x, y, width, height
    }

    // Información de la empresa
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->SetFont('Arial', 'B', 16);
    $pdf->SetXY(50, 12);
    $pdf->Cell(0, 8, mb_convert_encoding(strtoupper($regn['nombre']), 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    $pdf->SetFont('Arial', '', 9);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->SetXY(50, 22);
    $pdf->Cell(0, 4, mb_convert_encoding($regn['ndocumento'] . ": " . $regn['documento'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');
    $pdf->SetX(50);
    $pdf->Cell(0, 4, mb_convert_encoding($regn['direccion'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');
    $pdf->SetX(50);
    $pdf->Cell(0, 4, mb_convert_encoding("Teléfono: " . $regn['telefono'], 'ISO-8859-1', 'UTF-8'), 0, 1, 'L');

    // Información del comprobante en el header
    $pdf->SetFont('Arial', '', 9);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->SetXY(145, 12);
    $pdf->Cell(25, 5, 'No. Recibo:', 0, 0, 'L');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(0, 5, str_pad($rspta['id'], 9, '0', STR_PAD_LEFT), 0, 1, 'L');

    $pdf->SetFont('Arial', '', 9);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->SetXY(145, 18);
    $pdf->Cell(25, 5, 'Fecha:', 0, 0, 'L');
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(0, 5, $rspta['fecha_pago'], 0, 1, 'L');

    // Estado compacto y elegante
    $estadoColor = ($rspta['estado'] == '1') ? $colorExito : $colorAlerta;
    $estadoTexto = ($rspta['estado'] == '1') ? 'PAGADO' : 'PENDIENTE';

    $pdf->SetFillColor($estadoColor[0], $estadoColor[1], $estadoColor[2]);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY(145, 26);
    $pdf->Cell(40, 6, $estadoTexto, 0, 0, 'C', true);

    // Reset position
    $pdf->SetY(50);

    // === TÍTULO PRINCIPAL ===
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->SetFont('Arial', 'B', 20);
    $pdf->Cell(0, 12, 'FACTURA DE AGUA POTABLE', 0, 1, 'C');

    // Línea decorativa
    $pdf->SetDrawColor($colorAcento[0], $colorAcento[1], $colorAcento[2]);
    $pdf->SetLineWidth(0.8);
    $pdf->Line(80, $pdf->GetY() + 2, 130, $pdf->GetY() + 2);
    $pdf->Ln(15);

    // === INFORMACIÓN DEL CLIENTE ===
    $pdf->SetFillColor($colorFondo[0], $colorFondo[1], $colorFondo[2]);
    $pdf->Rect(15, $pdf->GetY(), 180, 35, 'F');

    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->SetXY(20, $pdf->GetY() + 5);
    $pdf->Cell(0, 8, 'DATOS DEL CLIENTE', 0, 1, 'L');

    $currentY = $pdf->GetY();

    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->SetXY(20, $currentY + 2);
    $pdf->Cell(25, 6, 'Nombre:', 0, 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(0, 6, mb_convert_encoding($rspta['cliente'], 'ISO-8859-1', 'UTF-8'), 0, 1);

    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->SetX(20);
    $pdf->Cell(25, 6, mb_convert_encoding('Cédula:', 'ISO-8859-1', 'UTF-8'), 0, 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(60, 6, $rspta['numDocumentoCliente'], 0, 0);

    // Dirección en la misma línea
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->Cell(30, 6, mb_convert_encoding('Dirección:', 'ISO-8859-1', 'UTF-8'), 0, 0);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(0, 6, mb_convert_encoding($rspta['direccionCliente'], 'ISO-8859-1', 'UTF-8'), 0, 1);

    $pdf->Ln(20);

    // === DETALLES DE CONSUMO ===
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(0, 8, 'DETALLE DE CONSUMO', 0, 1, 'L');

    $pdf->SetDrawColor($colorAcento[0], $colorAcento[1], $colorAcento[2]);
    $pdf->SetLineWidth(0.3);
    $pdf->Line(15, $pdf->GetY(), 195, $pdf->GetY());
    $pdf->Ln(8);

    // Tabla de consumo en formato de cuadrícula
    $pdf->SetFillColor($colorFondo[0], $colorFondo[1], $colorFondo[2]);

    // Primera fila
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->Cell(45, 8, 'Periodo:', 1, 0, 'L', true);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(45, 8, date('d/m/Y', strtotime($rspta['fecha_lectura'])), 1, 0, 'C');

    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->Cell(45, 8, 'Lectura Anterior:', 1, 0, 'L', true);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(45, 8, mb_convert_encoding($rspta['lectura_anterior'] . " m³", 'ISO-8859-1', 'UTF-8'), 1, 1, 'C');

    // Segunda fila
    $pdf->SetFont('Arial', '', 10);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->Cell(45, 8, 'Lectura Actual:', 1, 0, 'L', true);
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(45, 8, mb_convert_encoding($rspta['lectura_actual'] . " m³", 'ISO-8859-1', 'UTF-8'), 1, 0, 'C');

    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFillColor($colorAcento[0], $colorAcento[1], $colorAcento[2]);
    $pdf->Cell(45, 8, 'CONSUMO TOTAL:', 1, 0, 'L', true);
    $pdf->Cell(45, 8, mb_convert_encoding($rspta['consumo'] . " m³", 'ISO-8859-1', 'UTF-8'), 1, 1, 'C', true);

    $pdf->Ln(15);

    // === DETALLE DE PAGO ===
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->Cell(0, 8, 'DETALLE DE PAGO', 0, 1, 'L');

    $pdf->SetDrawColor($colorAcento[0], $colorAcento[1], $colorAcento[2]);
    $pdf->Line(15, $pdf->GetY(), 195, $pdf->GetY());
    $pdf->Ln(8);

    // Tabla de pago moderna
    $pdf->SetFillColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Cell(120, 10, 'CONCEPTO', 1, 0, 'C', true);
    $pdf->Cell(60, 10, 'MONTO ($)', 1, 1, 'C', true);

    $pdf->SetFillColor(255, 255, 255);
    $pdf->SetTextColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->SetFont('Arial', '', 10);
    $pdf->Cell(120, 10, mb_convert_encoding('Servicio de agua potable', 'ISO-8859-1', 'UTF-8'), 1, 0, 'L', true);
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->Cell(60, 10, number_format($rspta['monto'], 2, '.', ','), 1, 1, 'C', true);

    $pdf->Ln(8);

    // === TOTAL DESTACADO ===
    $pdf->SetFillColor($colorPrimario[0], $colorPrimario[1], $colorPrimario[2]);
    $pdf->SetTextColor(255, 255, 255);
    $pdf->SetFont('Arial', 'B', 14);
    $pdf->Cell(120, 12, 'TOTAL A PAGAR:', 1, 0, 'R', true);
    $pdf->Cell(60, 12, '$ ' . number_format($rspta['monto'], 2, '.', ','), 1, 1, 'C', true);

    // === PIE DE PÁGINA ELEGANTE ===
    $pdf->Ln(25);
    $pdf->SetDrawColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->SetLineWidth(0.2);
    $pdf->Line(15, $pdf->GetY(), 195, $pdf->GetY());
    $pdf->Ln(8);

    $pdf->SetFont('Arial', 'I', 9);
    $pdf->SetTextColor($colorSecundario[0], $colorSecundario[1], $colorSecundario[2]);
    $pdf->Cell(0, 5, 'Gracias por su pago oportuno y por confiar en nuestros servicios', 0, 1, 'C');
    $pdf->Cell(0, 5, mb_convert_encoding('Servicio de Agua Potable © ' . date('Y') . ' - Todos los derechos reservados', 'ISO-8859-1', 'UTF-8'), 0, 1, 'C');

    // Nombre del archivo
    $nombreComprobante = 'FACTURA_AGUA_' . str_pad($rspta['id'], 9, '0', STR_PAD_LEFT);

    // Salida del PDF
    $pdf->Output($nombreComprobante . '.pdf', 'I');
    exit;
  }

  // Versión cuadrada compacta
public function mostrarQrCuadradoCustomer($code): void
{
    $customer = new Client();
    $company = new Company();
    $dataCompany = $company->mostrar(1);
    $dataCustomer = $customer->mostrarPorDocumento($code);
        $pdf = new Fpdf($orientation = 'P', $unit = 'mm', array(80, 350));
    // Tamaño carnet ampliado para mejor legibilidad (100 x 65 mm)
    $pdf = new Fpdf('L', 'mm', array(100, 65));
    $pdf->AddPage();
    $pdf->SetMargins(0, 0, 0);
    $pdf->SetAutoPageBreak(false);

    // Fondo principal - Azul agua limpia
    $pdf->SetFillColor(240, 248, 255); // Alice Blue muy suave
    $pdf->Rect(0, 0, 100, 65, 'F');

    // Franja superior con degradado visual - Azul agua profunda
    $pdf->SetFillColor(30, 144, 255); // Dodger Blue (azul agua profunda)
    $pdf->Rect(0, 0, 100, 16, 'F');

    // Franja decorativa inferior de la cabecera
    $pdf->SetFillColor(135, 206, 235); // Sky Blue
    $pdf->Rect(0, 16, 100, 2, 'F');

    // Título principal "CARNET DE ASISTENCIA"
    $pdf->SetTextColor(255, 255, 255); // Blanco
    $pdf->SetFont('Arial', 'B', 11);
    $pdf->SetXY(2, 3);
    $titulo = $this->utf8_decode_safe('CARNET DE ASISTENCIA');
    $pdf->Cell(96, 4, $titulo, 0, 1, 'C');

    // Subtítulo empresa
    $pdf->SetFont('Arial', '', 9);
    $pdf->SetXY(2, 7.5);
    $subtitulo = $this->utf8_decode_safe($dataCompany['nombre']);
    $pdf->Cell(96, 3, $subtitulo, 0, 1, 'C');

    // Línea decorativa con ícono de gota (simulado con texto)
    $pdf->SetFont('Arial', '', 7);
    $pdf->SetXY(2, 11.5);
    $pdf->Cell(96, 3, '~ SISTEMA DE AGUA POTABLE ~', 0, 1, 'C');

    // Separadores visuales elegantes
    $pdf->SetDrawColor(255, 255, 255);
    $pdf->SetLineWidth(0.5);
    $pdf->Line(10, 15, 90, 15);

    // Marco decorativo para la sección de información
    $pdf->SetDrawColor(70, 130, 180); // Steel Blue
    $pdf->SetLineWidth(0.3);
    $pdf->Rect(4, 21, 54, 38, 'D');

    // Fondo sutil para información del cliente
    $pdf->SetFillColor(248, 252, 255); // Azul muy claro
    $pdf->Rect(4.5, 21.5, 53, 37, 'F');

    // Sección izquierda - Información del cliente
    $pdf->SetTextColor(25, 25, 112); // Midnight Blue para mejor legibilidad
    
    // Etiqueta "SOCIO/CLIENTE:"
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY(6, 24);
    $pdf->Cell(20, 3, 'SOCIO/CLIENTE:', 0, 0, 'L');
    
    // Nombre del cliente con salto de línea automático
    $pdf->SetFont('Arial', '', 8);
    $nombreCliente = $this->utf8_decode_safe(mb_strtoupper($dataCustomer['name'].$dataCustomer['last_name'] ?? '', 'UTF-8'));
    
    // Función para dividir texto en múltiples líneas
    $maxWidth = 48; // Ancho máximo para el texto
    $pdf->SetXY(6, 27.5);
    
    // Dividir el nombre en líneas si es muy largo
    $words = explode(' ', $nombreCliente);
    $line = '';
    $lineHeight = 3;
    $currentY = 28;
    
    foreach ($words as $word) {
        $testLine = $line . ($line ? ' ' : '') . $word;
        $testWidth = $pdf->GetStringWidth($testLine);
        
        if ($testWidth > $maxWidth && $line !== '') {
            $pdf->SetXY(6, $currentY);
            $pdf->Cell($maxWidth, $lineHeight, $line, 0, 1, 'L');
            $line = $word;
            $currentY += $lineHeight;
        } else {
            $line = $testLine;
        }
    }
    
    // Imprimir la última línea
    if ($line) {
        $pdf->SetXY(6, $currentY);
        $pdf->Cell($maxWidth, $lineHeight, $line, 0, 1, 'L');
        $currentY += $lineHeight;
    }

    // Separador visual
    $pdf->SetDrawColor(135, 206, 235);
    $pdf->SetLineWidth(0.2);
    $pdf->Line(6, $currentY + 1, 55, $currentY + 1);

    // Etiqueta "CÓDIGO:"
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY(6, $currentY + 3);
    $pdf->Cell(20, 3, $this->utf8_decode_safe('DOCUMENTO:'), 0, 0, 'L');
    
    // Código con estilo destacado
    $pdf->SetFont('Arial', 'B', 10);
    $pdf->SetTextColor(30, 144, 255); // Azul destacado
    $pdf->SetXY(6, $currentY + 7);
    $pdf->Cell(48, 3, $code, 0, 1, 'L');

    // Separador visual
    $pdf->SetDrawColor(135, 206, 235);
    $pdf->SetLineWidth(0.2);
    $pdf->Line(6, $currentY + 11, 55, $currentY + 11);

    // Fecha de emisión
    $pdf->SetTextColor(25, 25, 112);
    $pdf->SetFont('Arial', 'B', 8);
    $pdf->SetXY(6, $currentY + 13);
    $pdf->Cell(20, 3, 'EMITIDO:', 0, 0, 'L');
    
    $pdf->SetFont('Arial', '', 8);
    $pdf->SetXY(6, $currentY + 18);
    $fecha = date('d/m/Y H:i');
    $pdf->Cell(48, 3, $fecha, 0, 1, 'L');

    // Validez del carnet
    /*$pdf->SetFont('Arial', 'B', 7);
    $pdf->SetXY(6, $currentY + 20);
    $pdf->Cell(20, 3, 'VIGENCIA:', 0, 0, 'L');
    
    $pdf->SetFont('Arial', '', 7);
    $pdf->SetXY(6, $currentY + 23);
    $fechaVigencia = date('d/m/Y', strtotime('+1 year'));
    $pdf->Cell(48, 3, $fechaVigencia, 0, 1, 'L');*/

    // Sección derecha - QR Code con diseño mejorado
    // Marco principal del QR
    $pdf->SetDrawColor(30, 144, 255); // Azul principal
    $pdf->SetLineWidth(1.2);
    $pdf->Rect(61, 21, 35, 35, 'D');

    // Marco interno decorativo
    $pdf->SetDrawColor(135, 206, 235);
    $pdf->SetLineWidth(0.5);
    $pdf->Rect(62, 22, 33, 33, 'D');

    // Fondo blanco para el QR
    $pdf->SetFillColor(255, 255, 255);
    $pdf->Rect(63, 23, 31, 31, 'F');

    // Generar QR con mejor posicionamiento
    $qrcode = new QRcode($code, 'M');
    $qrcode->displayFPDF($pdf, 62, 22, 33, array(255, 255, 255), array(0, 0, 0));

    // Etiqueta del QR
    $pdf->SetTextColor(70, 130, 180);
    $pdf->SetFont('Arial', 'B', 6);
    $pdf->SetXY(61, 57);
    $pdf->Cell(35, 2, 'ESCANEAR PARA VERIFICAR', 0, 1, 'C');

    // Pie de página mejorado
    $pdf->SetTextColor(70, 130, 180);
    $pdf->SetFont('Arial', 'I', 7);
    $pdf->SetXY(2, 61);
    $piePagina = $this->utf8_decode_safe('Válido únicamente para control de asistencia - No transferible');
    $pdf->Cell(96, 3, $piePagina, 0, 1, 'C');

    // Elemento decorativo - Líneas de agua estilizadas
    $pdf->SetDrawColor(135, 206, 235);
    $pdf->SetLineWidth(0.3);
    // Líneas onduladas simuladas
    for ($i = 0; $i < 6; $i++) {
        $y = 64 + ($i * 0.3);
        $pdf->Line(15 + ($i * 2), $y, 25 + ($i * 2), $y);
        $pdf->Line(75 - ($i * 2), $y, 85 - ($i * 2), $y);
    }

    // Bordes principales del carnet
    $pdf->SetDrawColor(30, 144, 255);
    $pdf->SetLineWidth(1);
    $pdf->Rect(0.5, 0.5, 99, 64, 'D');

    // Borde interior elegante
    $pdf->SetDrawColor(135, 206, 235);
    $pdf->SetLineWidth(0.3);
    $pdf->Rect(1.5, 1.5, 97, 62, 'D');

    // Esquinas redondeadas simuladas con pequeños arcos
    $pdf->SetDrawColor(30, 144, 255);
    $pdf->SetLineWidth(0.5);
    // Esquinas decorativas (simuladas con líneas cortas)
    $pdf->Line(2, 2, 5, 2);
    $pdf->Line(2, 2, 2, 5);
    $pdf->Line(95, 2, 98, 2);
    $pdf->Line(98, 2, 98, 5);
    $pdf->Line(2, 63, 5, 63);
    $pdf->Line(2, 63, 2, 60);
    $pdf->Line(95, 63, 98, 63);
    $pdf->Line(98, 63, 98, 60);

    $pdf->Output('carnet_asistencia_' . $code . '.pdf', 'I');
    exit;
}

  /**
   * Función auxiliar para manejo seguro de UTF-8 compatible con PHP 8.3
   */
  private function utf8_decode_safe(string $text): string
  {
    // Verificar si la función utf8_decode existe (deprecada en PHP 8.2+)
    /*if (function_exists('utf8_decode')) {
        return utf8_decode($text);
    }*/
    //$texto = mb_convert_encoding($dataCustomer['name'], 'ISO-8859-1', 'UTF-8');
    // Alternativa compatible con PHP 8.3
    return mb_convert_encoding($text, 'ISO-8859-1', 'UTF-8');
  }
}
