<?php

namespace App\Controllers;

use App\Models\Meter;
use App\Models\Zone;

class MeterController extends Controller
{
	private $meter;

	public function __construct()
	{
		$this->meter = new Meter();
	}

	public function index(){
		$zone = new Zone();
		$zones = $zone->listar();
		return $this->view('meters.index',['title'=>'Medidores','zones'=>$zones]);
	}
	
	public function guardaryeditar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$series = isset($_POST["series"]) ? $_POST["series"] : "";
		$location = isset($_POST["location"]) ? $_POST["location"] : "";
		$client_id = isset($_POST["client_id"]) ? $_POST["client_id"] : "";
		$zone_id = isset($_POST["zone_id"]) ? $_POST["zone_id"] : "";

		if (empty($id)) {
			$rspta = $this->meter->insertar($series, $location, $client_id,$zone_id);
			return $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
		} else {
			$rspta = $this->meter->editar($id, $series, $location, $client_id,$zone_id);
			return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}

	public function mostrar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->meter->mostrar($id);
		return json_encode($rspta);
	}

	public function listar()
	{
		$rspta = $this->meter->listar();
		$data = array();


		foreach ($rspta as $reg) {
			$urlt = 'report-meter/qr/';
			$opciones =  '<a target="_blank" href="' . $urlt . $reg['series'] . '"> <button title="Imprimir" class="btn btn-info btn-sm"><i class="fas fa-qrcode"></i></button></a>';
			$data[] = array(
				"0" => '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['id'] . ')"><i class="fas fa-pencil-alt"></i></button>'.' '. $opciones,
				"1" => $reg['series'],
				"2" => $reg['location'],
				"3" => $reg['client'],
				"4" => $reg['barrio'],
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}

	public function listaReading()
	{
				$zoneId = null;
		if($_SESSION['zone_id']){
			$zoneId = $_SESSION['zone_id'];
		}
		$rspta = $this->meter->listaReading($zoneId);
		$data = array();


		foreach ($rspta as $reg) {
					
			$data[] = array(
				"0" => '<button class="btn btn-info btn-sm icon fas fa-arrow-circle-right" id="adcliente" onclick="agregarCliente(' . $reg['id'] . ',' . $reg['series'] . ',' . $reg['last_reading'] . ',\'' . $reg['client'] . '\','.$reg['client_id'].')"></button>',
				"1" => $reg['series'],
				"2" => $reg['location'],
				"3" => $reg['client'],
				"4" => $reg['cedula'],
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		echo json_encode($results);
		exit;
	}

	public function selectMeter()
	{
		$rspta = $this->meter->select();
		echo '<option value="">Seleccione...</option>';
		foreach ($rspta as $reg) {

			echo '<option value="' . $reg['id'] . '">' . $reg['series'] . '</option>';
		}
	}


}
