<?php

namespace App\Controllers;

use App\Models\Expense;


class ExpenseController extends Controller
{
	private $expense;

	public function __construct()
	{
		$this->expense = new Expense();
	}

	public function index()
	{
		return $this->view('expenses.index', ['title' => 'Gastos']);
	}

	public function guardaryeditar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$concept = isset($_POST["concept"]) ? $_POST["concept"] : "";
		$type = isset($_POST["type"]) ? $_POST["type"] : "";
		$amount = isset($_POST["amount"]) ? $_POST["amount"] : "";
		$date = isset($_POST["date"]) ? $_POST["date"] : "";
		if (empty($id)) {
			$rspta = $this->expense->insertar($concept, $type, $amount, $date);
			echo $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
		} else {
			$rspta = $this->expense->editar($id, $concept, $type, $amount, $date);
			echo $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}


	public function mostrar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->expense->mostrar($id);
		echo json_encode($rspta);
	}

	public function listar()
	{
		$rspta = $this->expense->listar();
		$data = array();


		foreach ($rspta as $reg) {
			$data[] = array(
				"0" => '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['id'] . ')"><i class="fas fa-pencil-alt"></i></button>',
				"1" => $reg['concept'],
				"2" => $reg['type'],
				"3" => number_format($reg['amount'], 2, ',', '.'),
				"4" => $reg['date']
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		echo json_encode($results);
	}

}
