<?php

namespace App\Controllers;

use App\Models\Client;
use App\Models\Zone;


class CustomerController extends Controller
{
	private $person;

	public function __construct()
	{
		$this->person = new Client();
	}

	public function index()
	{
		$zone = new Zone();
		$zones = $zone->listar();
		return $this->view('customers.index', ['zones' => $zones, 'title' => 'Socios']);
	}

	public function guardaryeditar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$name = isset($_POST["name"]) ? $_POST["name"] : "";
		$last_name = isset($_POST["last_name"]) ? $_POST["last_name"] : "";
		$document_number = isset($_POST["document_number"]) ? $_POST["document_number"] : "";
		$address = isset($_POST["address"]) ? $_POST["address"] : "";
		$phone = isset($_POST["phone"]) ? $_POST["phone"] : "";
		$email = isset($_POST["email"]) ? $_POST["email"] : "";
		//$zone_ids = isset($_POST["zone_ids"]) ? $_POST["zone_ids"] : "";
		$zone_ids = json_decode($_POST['zone_ids'], true) ?? [];

		if (empty($id)) {
			$rspta = $this->person->insertar($name, $last_name, $document_number, $address, $phone, $email, $zone_ids);
			return $rspta ? "Datos registrados correctamente" : "No se pudo registrar los datos";
		} else {
			$rspta = $this->person->editar($id, $name, $last_name, $document_number, $address, $phone, $email, $zone_ids);
			return $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
		}
	}

	public function eliminar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->person->eliminar($id);
		return $rspta ? "Datos eliminados correctamente" : "No se pudo eliminar los datos";
	}

	public function mostrar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->person->mostrar($id);
		return json_encode($rspta);
	}

	public function listar()
	{

		$zone_id = isset($_REQUEST["zone_id"]) ? $_REQUEST["zone_id"] : NULL;
		$rspta = $this->person->listar($zone_id);
		$data = array();
		$urlt = 'report-customer/qr/';
		foreach ($rspta as $reg) {
			$opciones =  '<a target="_blank" href="' . $urlt . $reg['document_number'] . '"> <button title="Imprimir" class="btn btn-info btn-sm"><i class="fas fa-qrcode"></i></button></a>';
			$data[] = array(
				"0" => '<button class="btn btn-warning btn-sm" onclick="mostrar(' . $reg['id'] . ')">
                   <i class="fas fa-pencil-alt"></i></button> ' .
					'<button class="btn btn-danger btn-sm" onclick="eliminar(' . $reg['id'] . ')">
                   <i class="fas fa-trash-alt"></i></button>',
				"1" => $reg['name'] . ' ' . $reg['last_name'],
				"2" => $reg['document_number'],
				"3" => $reg['phone'],
				"4" => $reg['address'],
				"5" => $reg['email'],
				"6" => $opciones,
				"7" => $reg['zones'] ?? 'Sin zonas asignadas',
			);
		}

		$results = array(
			"sEcho" => 1,
			"iTotalRecords" => count($data),
			"iTotalDisplayRecords" => count($data),
			"aaData" => $data
		);

		return json_encode($results);
	}

	public function selectClient()
	{
		$rspta = $this->person->select();
		echo '<option value="">Seleccione...</option>';
		foreach ($rspta as $reg) {
			echo '<option value="' . $reg['id'] . '">' . $reg['name'] . ' ' . $reg['last_name'] . '</option>';
		}
	}

	public function searchClient()
	{
		$param = isset($_POST["query"]) ? $_POST["query"] : "";
		$rspta = $this->person->buscar($param);

		$clientes = [];
		foreach ($rspta as $cliente) {
			$clientes[] = [
				'id' => $cliente['id'],
				'nombre_completo' => $cliente['client'],
				'texto_busqueda' => $cliente['client'] . ' - ' . $cliente['document_number'] . ' (Medidor: ' . $cliente['series'] . ')'
			];
		}

		echo json_encode([
			'status' => true,
			'clientes' => $clientes
		]);
		exit;
	}
}
