<?php
namespace App\Controllers;

class Controller {
    
        public function view($view, $data = [], $layout = null) {
            // Destructurar array de datos
            extract($data);
            
            // Reemplazar puntos por barras para las rutas de vista
            $viewPath = str_replace('.', '/', $view);
  //          $vista = str_replace(['.', '/'], ' ', $view); // Reemplaza . y / por espacios
//$currentView = explode(' ', $vista)[0]; // Obtiene la 
            // Variable con el nombre de la vista
            $currentView = $viewPath;
            // Verificar si la vista existe
            if (file_exists("../resources/views/{$viewPath}.php")) {
                ob_start(); // Iniciar el almacenamiento en búfer
                require_once "../resources/views/{$viewPath}.php"; // Incluir la vista
                $content = ob_get_clean(); // Obtener el contenido de la vista
    
                // Si se proporciona un layout, usarlo
                if ($layout && file_exists("../resources/views/layouts/{$layout}.php")) {
                    require_once "../resources/views/layouts/{$layout}.php";
                } elseif (file_exists("../resources/views/layouts/layout.php")) {
                    require_once "../resources/views/layouts/layout.php";
                } else {
                    echo $content; // Mostrar el contenido sin layout
                }
            } else {
                echo "La vista no existe";
            }
        }

}
