<?php

namespace App\Controllers;

use App\Controllers\Controller;
use App\Models\Company;
use Exception;

class CompanyController extends Controller
{
	private $id_negocio;
	private $company;

	public function __construct()
	{
		$this->id_negocio = 1;
		$this->company = new Company();
	}

	public function setting()
	{
		return $this->view('company.setting', ['title' => 'Ajustes']);
	}

	public function guardaryeditar()
	{
		try{
    // Recoger datos del formulario
    $nombre = $_POST["nombre"] ?? "";
    $ndocumento = $_POST["ndocumento"] ?? "";
    $documento = $_POST["documento"] ?? "";
    $direccion = $_POST["direccion"] ?? "";
    $telefono = $_POST["telefono"] ?? "";
    $email = $_POST["email"] ?? "";
    $cost_water = $_POST["cost_water"] ?? "";
    $max_cubic = $_POST["max_cubic"] ?? "";
    $price_cubic = $_POST["price_cubic"] ?? "";
    $fine_meet = $_POST["fine_meet"] ?? "";
    $imagen = $_POST["imagen"] ?? "";

    // Configuración de directorio de uploads
    $upload_dir = dirname(__DIR__, 2) . '/public/assets/img/company/';
    
    // Verificar y crear directorio si no existe
    if (!file_exists($upload_dir)) {
        mkdir($upload_dir, 0755, true);
    }

    // Manejo de la imagen
    if (!empty($_FILES['imagen']['tmp_name']) && is_uploaded_file($_FILES['imagen']['tmp_name'])) {
        // Eliminar imagen anterior si existe
        if (!empty($_POST["imagenactual"]) && $_POST["imagenactual"] != 'default.jpg') {
            $old_image_path = $upload_dir . $_POST["imagenactual"];
            if (file_exists($old_image_path)) {
                unlink($old_image_path);
            }
        }

        // Validar tipo de imagen
        $allowed_types = ['image/jpg', 'image/jpeg', 'image/png'];
        $file_info = finfo_open(FILEINFO_MIME_TYPE);
        $mime_type = finfo_file($file_info, $_FILES['imagen']['tmp_name']);
        finfo_close($file_info);

        if (in_array($mime_type, $allowed_types)) {
            $ext = pathinfo($_FILES["imagen"]["name"], PATHINFO_EXTENSION);
            $imagen = uniqid('company_', true) . '.' . $ext;
            
            if (!move_uploaded_file($_FILES["imagen"]["tmp_name"], $upload_dir . $imagen)) {
                $imagen = $_POST["imagenactual"] ?? 'default.jpg';
                error_log("Error al mover la imagen: " . $_FILES['imagen']['error']);
            }
        } else {
            $imagen = $_POST["imagenactual"] ?? 'default.jpg';
            error_log("Tipo de archivo no permitido: " . $mime_type);
        }
    } else {
        $imagen = $_POST["imagenactual"] ?? 'default.jpg';
    }

		$rspta = $this->company->editar($this->id_negocio, $nombre, $ndocumento, $documento, $direccion, $telefono, $email, $imagen, $cost_water, $max_cubic, $price_cubic,$fine_meet);
		echo $rspta ? "Datos actualizados correctamente" : "No se pudo actualizar los datos";
	}catch (Exception $e) {
       // http_response_code(500);
        error_log($e->getMessage());
        echo "Error: " . $e->getMessage();
    }

}

	public function mostrar()
	{
		$rspta = $this->company->mostrar($this->id_negocio);
		echo json_encode($rspta);
	}

	/*public function mostrar_impuesto':
		$rspta = $this->company->mostrar_impuesto();
		$data = array();

		foreach ($rspta as $reg) {
			$data[] = array(
				$numeroimp = $reg['monto_impuesto']

			);
		}
		$impuesto = (floatval($numeroimp));
		echo json_encode($impuesto);
	}*/

	/*public function nombre_impuesto':
		$rspta = $this->company->nombre_impuesto();
		$data = array();

		foreach ($rspta as $reg) {
			$data[] = array(
				$nombreimp = $reg['nombre_impuesto']

			);
		}
		echo json_encode($nombreimp);
	}*/

	/*public function mostrar_simbolo':
		$rspta = $this->company->mostrar_simbolo();
		$data = array();

		foreach ($rspta as $reg) {
			$data[] = array(
				$simbolo = $reg['simbolo']
			);
		}
		echo json_encode($simbolo);
	}*/

	public function mostrar_datos()
	{
		$rspta = $this->company->mostrar($this->id_negocio);
		echo json_encode($rspta);
	}

	/*public function listar':
		$rspta = $this->company->listar();
		$data = array();

		foreach ($rspta as $reg) {
			$data[] = array(
				"0" => '<button class="btn btn-warning btn-xs" id="btn_lista" onclick="mostrar(' . $reg['id_negocio'] . ')"><i class="fas fa-edit"></i></button>',
				"1" => "<img src='assets/img/company/" . $reg['logo'] . "' height='50px' width='50px'>",
				"2" => $reg['nombre'],
				"3" => $reg['ndocumento'] . '-' . $reg['documento'],
				"4" => $reg['direccion'],
				"5" => $reg['telefono'],
				"6" => $reg['email'],
				"7" => $reg['ciudad'] . '-' . $reg['pais'],
				"8" => $reg['nombre_impuesto'] . ' ' . $reg['monto_impuesto'] . ' %',
				"9" => $reg['simbolo'] . '- ' . $reg['moneda'],
				"10" => ($reg['condicion']) ? '<span class="label bg-green">Activado</span>' : '<span class="label bg-red">Desactivado</span>'
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		echo json_encode($results);
	}*/
}
