<?php

namespace App\Controllers;

use App\Models\Attendance;
use App\Models\Client;
use App\Models\Meeting;
use App\Models\Zone;

class AttendanceController extends Controller
{

	private $attendance;

	public function __construct()
	{
		$this->attendance = new Attendance();
	}

	public function index($id)
	{
		$zone = new Zone();
		$zones = $zone->listar();
		$customer = new Client();
		$attendance = $this->attendance->verificarLista($id);
		$customers = $customer->listarParaAsistencia();
		if (!$attendance) {
			foreach ($customers as $customer) {
				$this->attendance->insertar($customer['id'], $id, '0');
			}
		}
		$meeting = new Meeting();
		$meetingStatus = $meeting->mostrar($id);
		$status = $meetingStatus['status'];
		return $this->view('attendances.index', ['title' => 'Asistencias', 'id' => $id, 'status' => $status, 'zones' => $zones], 'layout');
	}

	public function registrar()
	{

		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$tipo = isset($_POST["tipo"]) ? $_POST["tipo"] : 0;

		$rspta = $this->attendance->editar($id, $tipo);
		return $rspta ? "Asistencia registrado" : "No se pudo registrar la asistenca";
	}

	public function registerQr()
	{
		$document_number = trim($_REQUEST["document_number"] ?? '');
		//$tipo = isset($_POST["document_number"]) ? $_POST["document_number"] : 0;
		$id = isset($_POST["id"]) ? $_POST["id"] : null;
		$tipo = '1';
		$data = $this->attendance->searchClient($document_number);

		// Verificar si hay datos
		if ($data && !empty($data)) {
			$rspta = $this->attendance->editarQr($id, $tipo, $data['id']);
			$message = $rspta ? "Asistencia registrado" : "No se pudo registrar la asistencia";
			// Si hay datos, devolver success true con los datos
			$response = [
				'success' => $rspta,
				'message' => $message,
				//'data' => $data
			];
		} else {
			// Si no hay datos, devolver success false
			$response = [
				'success' => false,
				'message' => 'Socio no encontrado'
			];
		}

		//header('Content-Type: application/json');
		echo json_encode($response);
		exit;
	}

	public function registerAll()
	{

		$meeting_id = isset($_POST["meeting_id"]) ? $_POST["meeting_id"] : "";
		$tipo = isset($_POST["tipo"]) ? $_POST["tipo"] : 0;

		$rspta = $this->attendance->editarAll($meeting_id, $tipo);
		return $rspta ? "Asistencia registrado" : "No se pudo actualizar los datos";
	}

	public function mostrar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$rspta = $this->attendance->mostrar($id);
		return json_encode($rspta);
	}

	public function listar()
	{
		$id = isset($_POST["id"]) ? $_POST["id"] : "";
		$zone_id = isset($_POST["zone_id"]) ? $_POST["zone_id"] : "";
		$meeting = new Meeting();
		$meetingStatus = $meeting->mostrar($id);
		$status = $meetingStatus['status'];
		$active = !$status ? 'disabled' : '';
		$fechaActual = date('Y-m-d');
		$rspta = $this->attendance->listar($id, $zone_id);
		$data = array();

		foreach ($rspta as $reg) {
			$estado = ($reg['attendance'])
				? '<span class="badge bg-success">Asistió</span>'
				: '<span class="badge bg-danger"> Faltó</span>';
			$data[] = array(
				"0" => $reg['customer'],
				"1" => $reg['document_number'],
				"2" => $reg['phone'],
				"3" => $estado,
				"4" => $reg['attendance'] ? '<button class="btn btn-danger btn-sm" ' . $active . ' onclick="registrar(' . $reg['id'] . ',\'0\')"> <i class="fas fa-times"></i> Falta</button>' : '<button class="btn btn-success btn-sm" ' . $active . ' onclick="registrar(' . $reg['id'] . ',1)"><i class="fas fa-check"></i> Asistencia</button>',
			);
		}
		$results = array(
			"sEcho" => 1, //info para datatables
			"iTotalRecords" => count($data), //enviamos el total de registros al datatable
			"iTotalDisplayRecords" => count($data), //enviamos el total de registros a visualizar
			"aaData" => $data
		);
		return json_encode($results);
	}
}
